@php
    $setting = \App\Models\Utility::settings();
    $settings = \App\Models\Utility::settings(\Auth::user()->get_created_by());
    $setting_arr = Utility::file_validate();
@endphp
@if ($setting['cookie_consent'] == 'on')
    @include('layouts.cookie_consent')
@endif
<footer class="dash-footer">
    <div class="footer-wrapper">
        <div class="py-1">
            <span class="text-muted">
                &copy;{{ date(' Y') }}
                {{ App\Models\Utility::getValByName('footer_text') ? App\Models\Utility::getValByName('footer_text') : config('app.name', 'RotaGo') }}
            </span>
        </div>
    </div>
</footer>
<script>
    var file_size = "{{ $setting_arr['max_size'] }}";
    var file_types = "{{ $setting_arr['types'] }}";
    var type_err = "{{ __('Invalid file type. Please select a valid file ('.$setting_arr['types'].').') }}";
    var size_err = "{{ __('File size exceeds the maximum limit of '. $setting_arr['max_size'] / 1024 .'MB.') }}";
</script>
