@extends('layouts.main')
@section('page-title')
    {{ __('Landing Page') }}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item">{{ __('Landing Page') }}</li>
@endsection

@php
    $logo = \App\Models\Utility::get_file('uploads/logo');
    $settings = \Modules\LandingPage\Entities\LandingPageSetting::settings();
    $setting = \App\Models\Utility::settings();
@endphp

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item">{{ __('Landing Page') }}</li>
@endsection


@section('content')
    <div class="dash-container">
        <div class="dash-content">
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="page-header-title">
                                <h4 class="m-b-10">{{ __('Landing Page') }}</h4>
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('Dashboard') }}</a></li>
                                <li class="breadcrumb-item">{{ __('Landing Page') }}</li>
                            </ul>
                        </div>
                        <div class="col-md-6 d-flex justify-content-end text-right">

                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="row">
                        <div class="col-xl-3">
                            <div class="card sticky-top" style="top:30px">
                                <div class="list-group list-group-flush" id="useradd-sidenav">

                                    @include('landingpage::layouts.tab')


                                </div>
                            </div>
                        </div>

                        <div class="col-xl-9">
                            {{--  Start for all settings tab --}}
                            {{ Form::model(null, ['route' => ['landingpage.store'], 'method' => 'POST']) }}
                            @csrf
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center">
                                        <div class="col-6">
                                            <h5 class="mb-2">{{ __('Top Bar') }}</h5>
                                        </div>
                                        <div
                                            class="col switch-width {{ $setting['SITE_RTL'] == 'on' ? 'text-start' : 'text-end' }}">
                                            <div class="form-group mb-0">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" data-toggle="switchbutton" data-onstyle="primary"
                                                        class="" name="topbar_status" id="topbar_status"
                                                        {{ $settings['topbar_status'] == 'on' ? 'checked="checked"' : '' }}>
                                                    <label class="custom-control-label" for="topbar_status"></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="card-body">
                                    <div class="row">

                                        <div class="form-group col-12">
                                            {{ Form::label('content', __('Message'), ['class' => 'col-form-label text-dark']) }}
                                            {{ Form::textarea('topbar_notification_msg', $settings['topbar_notification_msg'], ['class' => 'summernote-simple form-control', 'required' => 'required']) }}
                                        </div>

                                    </div>
                                </div>
                                <div class="card-footer text-end">
                                    <input class="btn btn-print-invoice btn-primary m-r-10" type="submit"
                                        value="{{ __('Save Changes') }}">
                                </div>
                            </div>
                            {{ Form::close() }}

                            {{--  End for all settings tab --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
