@extends('layouts.main')
@section('page-title')
    {{ __('Settings') }}
@endsection
{{-- <script>
    [dir="rtl"] .dash-header {
        left: 0;
        right: 280px;
    }
</script> --}}
@php

    $lang = \App\Models\Utility::getValByName('default_language');
    $logo = \App\Models\Utility::get_file('uploads/logo/');
    $meta_image = \App\Models\Utility::get_file('uploads/meta_image/');

    $user = Auth::user();
    $file_type = config('files_types');
    $setting = App\Models\Utility::settings();

    $local_storage_validation = $setting['local_storage_validation'];
    $local_storage_validations = explode(',', $local_storage_validation);

    $s3_storage_validation = $setting['s3_storage_validation'];
    $s3_storage_validations = explode(',', $s3_storage_validation);

    $wasabi_storage_validation = $setting['wasabi_storage_validation'];
    $wasabi_storage_validations = explode(',', $wasabi_storage_validation);
    $settings = \App\Models\Utility::settings();
    // @dd($settings);
    $color = !empty($settings['color']) ? $settings['color'] : 'theme-3';
    $flag = !empty($settings['color_flag']) ? $settings['color_flag'] : 'false';
@endphp

@section('content')
    <div class="dash-container">
        <div class="dash-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="page-header-title">
                                <h4 class="m-b-10">{{ __('Settings') }}</h4>
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item">{{ __('Settings') }}</li>
                            </ul>
                        </div>
                        <div class="col-md-6 d-flex justify-content-end text-right">
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
            <div class="row">
                <div class="col-sm-12">
                    <div class="row">
                        <div class="col-xl-3">
                            <div class="card sticky-top" style="top:30px">
                                <div class="list-group list-group-flush" id="useradd-sidenav">
                                    <a href="#Dashbord_Setting"
                                        class="list-group-item list-group-item-action border-0 active">{{ __('Dashboard Settings') }}</a>

                                    <a href="#Site_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Site Settings') }}</a>

                                    <a href="#Company_setting"
                                        class="list-group-item list-group-item-action  border-0">{{ __('Company Settings') }}</a>

                                    <a href="#Email_Setting" class="list-group-item list-group-item-action border-0">
                                        {{ __('Email Settings') }}</a>

                                    <a href="#ip-restriction-settings"
                                        class="list-group-item list-group-item-action border-0">
                                        {{ __('IP Restriction Settings') }}</a>

                                    <a href="#Zoom_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Zoom Settings') }}</a>

                                    <a href="#Slack_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Slack Settings') }}</a>

                                    <a href="#Telegram_Setting"
                                        class="list-group-item list-group-item-action border-0  ">{{ __('Telegram Settings') }}</a>

                                    <a href="#Pusher_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Pusher Settings') }}</a>

                                    <a href="#ReCaptcha_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('ReCaptcha Settings') }}</a>

                                    <a href="#Storage_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Storage Setting') }}</a>

                                    <a href="#Google_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Google Calendar Settings') }}</a>

                                    <a href="#Seo_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('SEO Settings') }}</a>

                                    <a href="#Cache_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Cache Settings') }}</a>

                                    <a href="#Webhook_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Webhook Settings') }}</a>

                                    <a href="#Cookie_Setting"
                                        class="list-group-item list-group-item-action border-0">{{ __('Cookie Settings') }}</a>

                                    <a href="#pills-chatgpt-settings"
                                        class="list-group-item list-group-item-action border-0">{{ __('Chat GPT Settings') }}</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-9">
                            <!--Dashbord_Setting-->
                            <div id="Dashbord_Setting" class="card text-white">
                                <div class="card-header">
                                    <h5>{{ __('Dashboard Settings') }}</h5>
                                    <small class="text-muted">{{ __('Edit your dashboard settings') }}</small>
                                </div>
                                <div class="card-body">
                                    {{ Form::model($profile, ['route' => ['setting.update', $profile->id], 'method' => 'PUT', 'class' => 'permission_table_information']) }}
                                    {{ Form::hidden('employee_id', $profile->user_id) }}
                                    {{ Form::hidden('form_type', 'rotas_setting') }}
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                            <h5 class=" h6 mb-1">{{ __('Rota Settings') }}</h5>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6">
                                            <div class="form-check form-switch d-inline-block mx-2">
                                                {!! Form::checkbox('emp_show_rotas_price', 1, !empty($company_setting['emp_show_rotas_price']) ? 1 : 0, [
                                                    'required' => false,
                                                    'class' => 'custom-control-input form-check-input',
                                                    'id' => 'emp_show_rotas_price',
                                                    'role' => 'switch',
                                                ]) !!}
                                                {{ Form::label('emp_show_rotas_price', __('Show employee rotas price'), ['class' => 'custom-label text-dark']) }}
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6">
                                            <div class="form-check form-switch d-inline-block mx-2">
                                                {!! Form::checkbox('emp_show_avatars_on_rota', 1, !empty($company_setting['emp_show_avatars_on_rota']) ? 1 : 0, [
                                                    'required' => false,
                                                    'class' => 'custom-control-input form-check-input',
                                                    'id' => 'emp_show_avatars_on_rota',
                                                    'role' => 'switch',
                                                ]) !!}
                                                {{ Form::label('emp_show_avatars_on_rota', __('Show employee avatars on rota'), ['class' => 'custom-label text-dark']) }}
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6">
                                            <div class="form-check form-switch d-inline-block mx-2">
                                                {!! Form::checkbox('emp_hide_rotas_hour', 1, !empty($company_setting['emp_hide_rotas_hour']) ? 1 : 0, [
                                                    'required' => false,
                                                    'class' => 'custom-control-input form-check-input',
                                                    'id' => 'emp_hide_rotas_hour',
                                                    'role' => 'switch',
                                                ]) !!}
                                                {{ Form::label('emp_hide_rotas_hour', __('Hide employee rotas hour'), ['class' => 'custom-label text-dark']) }}
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6">
                                            <div class="form-check form-switch d-inline-block mx-2">
                                                {!! Form::checkbox(
                                                    'include_unpublished_shifts',
                                                    1,
                                                    !empty($company_setting['include_unpublished_shifts']) ? 1 : 0,
                                                    [
                                                        'required' => false,
                                                        'class' => 'custom-control-input form-check-input',
                                                        'id' => 'include_unpublished_shifts',
                                                        'role' => 'switch',
                                                    ],
                                                ) !!}
                                                {{ Form::label('include_unpublished_shifts', __('Include unpublished shifts on the dashboard and report'), ['class' => 'custom-label text-dark']) }}
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6">
                                            <div class="form-check form-switch d-inline-block mx-2">
                                                {!! Form::checkbox('emp_only_see_own_rota', 1, !empty($company_setting['emp_only_see_own_rota']) ? 1 : 0, [
                                                    'required' => false,
                                                    'class' => 'custom-control-input form-check-input',
                                                    'id' => 'emp_only_see_own_rota',
                                                    'role' => 'switch',
                                                ]) !!}
                                                {{ Form::label('emp_only_see_own_rota', __('Employees only see themselves on the rota'), ['class' => 'custom-label text-dark']) }}
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-6">
                                            <div class="form-check form-switch d-inline-block mx-2">
                                                {!! Form::checkbox(
                                                    'emp_can_see_all_locations',
                                                    1,
                                                    !empty($company_setting['emp_can_see_all_locations']) ? 1 : 0,
                                                    [
                                                        'required' => false,
                                                        'class' => 'custom-control-input form-check-input',
                                                        'id' => 'emp_can_see_all_locations',
                                                        'role' => 'switch',
                                                    ],
                                                ) !!}
                                                {{ Form::label('emp_can_see_all_locations', __('Employees can view the rotas of locations they are not assigned to'), ['class' => 'custom-label text-dark']) }}
                                            </div>
                                        </div>
                                        <br><br><br><br>
                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                            <div class="row">
                                                <div class="col-xs-12 col-sm-6 col-md-2">
                                                    {{ Form::label('', __('Week Starts'), ['class' => 'form-label text-dark h6']) }}
                                                    {!! Form::select(
                                                        'company_week_start',
                                                        [
                                                            'monday' => __('Monday'),
                                                            'tuesday' => __('Tuesday'),
                                                            'wednesday' => __('Wednesday'),
                                                            'thursday' => __('Thursday'),
                                                            'friday' => __('Friday'),
                                                            'saturday' => __('Saturday'),
                                                            'sunday' => __('Sunday'),
                                                        ],
                                                        !empty($company_setting['company_week_start']) ? $company_setting['company_week_start'] : null,
                                                        ['required' => true, 'data-placeholder' => __('Select Day'), 'class' => 'form-control js-single-select'],
                                                    ) !!}
                                                </div>
                                                <div class="col-xs-12 col-sm-6 col-md-2">
                                                    {{ Form::label('', __('Time Format'), ['class' => 'form-label text-dark h6']) }}
                                                    {!! Form::select(
                                                        'company_time_format',
                                                        ['12' => '12 ' . __('Hour'), '24' => '24 ' . __('Hour')],
                                                        !empty($company_setting['company_time_format']) ? $company_setting['company_time_format'] : null,
                                                        ['required' => true, 'data-placeholder' => 'Yours Time Type', 'class' => 'form-control js-single-select'],
                                                    ) !!}
                                                </div>
                                                <div class="col-xs-12 col-sm-6 col-md-2">
                                                    {{ Form::label('', __('Date Format'), ['class' => 'form-label text-dark h6']) }}
                                                    {!! Form::select(
                                                        'company_date_format',
                                                        [
                                                            'Y-m-d' => date('Y-m-d'),
                                                            'm-d-Y' => date('m-d-Y'),
                                                            'd-m-Y' => date('d-m-Y'),
                                                            'M j, Y' => date('M j, Y'),
                                                            'd M Y' => date('d M Y'),
                                                            'D d F Y' => date('D d F Y'),
                                                        ],
                                                        !empty($company_setting['company_date_format']) ? $company_setting['company_date_format'] : null,
                                                        ['required' => true, 'data-placeholder' => __('Select Day'), 'class' => 'form-control js-single-select'],
                                                    ) !!}
                                                </div>
                                                <div class="col-sm-4 col-md-3">
                                                    {{ Form::label('', __('Currency Symbol'), ['class' => 'form-label text-dark h6']) }}
                                                    {{ Form::text('company_currency_symbol', !empty($company_setting['company_currency_symbol']) ? $company_setting['company_currency_symbol'] : '$', ['class' => 'form-control']) }}
                                                </div>
                                                <div class="col-sm-6 col-md-3">
                                                    {{ Form::label('', __('Currency Position'), ['class' => 'form-label text-dark h6']) }}
                                                    <br>
                                                    <div class="custom-control custom-radio d-inline-block mx-2">
                                                        <input type="radio" name="company_currency_symbol_position"
                                                            value="pre" class="form-check-input"
                                                            id="company_currency_symbol_pre"
                                                            {{ $company_setting['company_currency_symbol_position'] == 'pre' ? 'checked' : '' }}>
                                                        <label class="custom-label text-dark"
                                                            for="company_currency_symbol_pre">{{ __('Pre') }}</label>
                                                    </div>
                                                    <div class="custom-control custom-radio d-inline-block mx-2">
                                                        <input type="radio" name="company_currency_symbol_position"
                                                            value="post" class="form-check-input"
                                                            id="company_currency_symbol_post"
                                                            {{ $company_setting['company_currency_symbol_position'] == 'post' ? 'checked' : '' }}>
                                                        <label class="custom-label text-dark"
                                                            for="company_currency_symbol_post">{{ __('Post') }}</label>
                                                    </div>
                                                </div>


                                            </div>
                                        </div>

                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-6 col-md-3">
                                            {{ Form::label('leave_year_start', __('Leave Year Starts'), ['class' => 'form-label text-dark h6']) }}
                                            {!! Form::select(
                                                'leave_start_month',
                                                [
                                                    '01' => __('January'),
                                                    '02' => __('February'),
                                                    '03' => __('March'),
                                                    '04' => __('April'),
                                                    '05' => __('May'),
                                                    '06' => __('June'),
                                                    '07' => __('July'),
                                                    '08' => __('August'),
                                                    '09' => __('September'),
                                                    '10' => __('October'),
                                                    '11' => __('November'),
                                                    '12' => __('December'),
                                                ],
                                                !empty($company_setting['leave_start_month']) ? $company_setting['leave_start_month'] : 1,
                                                ['required' => true, 'data-placeholder' => __('Select Month'), 'class' => 'form-control js-single-select'],
                                            ) !!}
                                        </div>
                                        <div class="col-xs-12 col-sm-6 col-md-3 ">
                                            {{ Form::label('breck_paid', __('Break'), ['class' => 'form-label text-dark h6']) }}
                                            <br>
                                            <div class="custom-control custom-radio d-inline-block mx-2">
                                                <input type="radio" name="break_paid" value="paid"
                                                    class="form-check-input"
                                                    {{ $company_setting['break_paid'] == 'paid' ? 'checked' : '' }}>
                                                <label class="custom-label text-dark">{{ __('Paid') }}</label>
                                            </div>

                                            <div class="custom-control custom-radio d-inline-block mx-2">
                                                <input type="radio" name="break_paid" value="unpaid"
                                                    class="form-check-input"
                                                    {{ $company_setting['break_paid'] == 'unpaid' ? 'checked' : '' }}>
                                                <label class="custom-label text-dark">{{ __('Unpaid') }}</label>
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-4">
                                            {{ Form::label('', __('Shift Notes'), ['class' => 'form-label text-dark h6']) }}
                                            {!! Form::select(
                                                'see_note',
                                                [
                                                    'none' => __('Only admins and managers can see shift notes'),
                                                    'self' => __('Employees can only see notes for their own shifts and open shifts'),
                                                    'all' => __('Employees can see shift notes for everybody'),
                                                ],
                                                !empty($company_setting['see_note']) ? $company_setting['see_note'] : null,
                                                ['required' => false, 'class' => 'form-control '],
                                            ) !!}
                                        </div>
                                    </div>
                                    <br>
                                    <div class="col-xs-12 col-sm-12 col-md-12">
                                        <div class="row">

                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                            <h5 class=" h6 mb-1">{{ __('Availability Preferences') }}</h5>
                                        </div>
                                        <div class="col-xs-12 col-sm-12 col-md-12">
                                            <div class="custom-control custom-checkbox d-inline-block mx-2">
                                                {!! Form::checkbox(
                                                    'employees_can_set_availability',
                                                    1,
                                                    !empty($company_setting['employees_can_set_availability']) ? $company_setting['employees_can_set_availability'] : 0,
                                                    ['required' => false, 'class' => 'form-check-input', 'id' => 'employees_can_set_availability'],
                                                ) !!}
                                                {{ Form::label('employees_can_set_availability', __('Employees can set their own availability preferences'), ['class' => 'custom-label text-dark']) }}
                                            </div>
                                        </div>
                                    </div>


                                    <div class="card-footer text-end py-0 pe-2 border-0  pt-4">
                                        <input name="from" type="hidden" value="password">
                                        <input name="from" type="hidden" value="password">
                                        <button type="submit" class="btn btn-primary">{{ __('Save Changes') }}</button>
                                    </div>
                                    {{ Form::close() }}
                                </div>
                            </div>

                            <!--Site_Setting-->
                            <div id="Site_Setting" class="card">
                                <div class="card-header">
                                    <h5>{{ __('Site Settings   ') }}</h5>
                                    <small class="text-muted">{{ __('Edit your Brand Settings') }}</small>
                                </div>
                                <div class="card-body">
                                    {{ Form::model($settings, ['route' => ['setting.update', $profile->id], 'method' => 'PUT', 'class' => 'permission_table_information', 'enctype' => 'multipart/form-data']) }}

                                    <div class="row mt-3">
                                        {{-- Light Logo --}}
                                        <div class="col-lg-4 col-sm-6 col-md-6">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h5>{{ __('Light Logo') }}</h5>
                                                </div>
                                                <div class="card-body pt-0">
                                                    <div class="setting-card">
                                                        <div class="logo-content mt-4">
                                                            <a href="{{ $logo . (isset($light_logo) && !empty($light_logo) ? $light_logo : 'logo-light.png' . '?timestemp=' . time()) }}"
                                                                target="_blank">
                                                                <img src="{{ $logo . (isset($light_logo) && !empty($light_logo) ? $light_logo : 'logo-light.png' . '?timestemp=' . time()) }}"
                                                                    class="big-logo img_setting" id="blah1"
                                                                    style="width: 150px"></a>
                                                        </div>
                                                        <div class="choose-files mt-5">
                                                            <label for="light_logo"
                                                                class="form-label choose-files bg-primary "><i
                                                                    class="ti ti-upload px-1"></i>{{ __('Select Image') }}</label>
                                                            <input type="file" name="light_logo" id="light_logo"
                                                                class="custom-input-file d-none"
                                                                onchange="document.getElementById('blah1').src = window.URL.createObjectURL(this.files[0])">
                                                        </div>

                                                        @error('light_logo')
                                                            <div class="row">
                                                                <span class="invalid-logo" role="alert">
                                                                    <strong class="text-danger">{{ $message }}</strong>
                                                                </span>
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {{-- Dark Logo --}}
                                        <div class="col-lg-4 col-sm-6 col-md-6">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h5>{{ __('Dark Logo') }}</h5>
                                                </div>
                                                <div class="card-body pt-0">
                                                    <div class="setting-card">
                                                        <div class="logo-content mt-4">
                                                            <a href="{{ $logo . (isset($dark_logo) && !empty($dark_logo) ? $dark_logo : 'logo-dark.png' . '?timestemp=' . time()) }}"
                                                                target="_blank">
                                                                <img src="{{ $logo . (isset($logo_dark) && !empty($logo_dark) ? $logo_dark : 'logo-dark.png' . '?timestemp=' . time()) }}"
                                                                    class="big-logo" id="blah"
                                                                    style="width: 150px"></a>
                                                        </div>
                                                        <div class="choose-files mt-5">
                                                            <label for="dark_logo"
                                                                class="form-label choose-files bg-primary "><i
                                                                    class="ti ti-upload px-1"></i>{{ __('Select Image') }}</label>
                                                            <input type="file" name="dark_logo" id="dark_logo"
                                                                class="custom-input-file d-none"
                                                                onchange="document.getElementById('blah').src = window.URL.createObjectURL(this.files[0])">
                                                        </div>
                                                        @error('dark_logo')
                                                            <div class="row">
                                                                <span class="invalid-logo" role="alert">
                                                                    <strong class="text-danger">{{ $message }}</strong>
                                                                </span>
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Favicon Logo --}}
                                        <div class="col-lg-4 col-sm-6 col-md-6">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h5>{{ __('Favicon') }}</h5>
                                                </div>
                                                <div class="card-body pt-0">
                                                    <div class="setting-card">
                                                        <div class="logo-content mt-4">
                                                            <a href="{{ $logo . (isset($favicon) && !empty($favicon) ? $favicon : 'favicon.png' . '?timestemp=' . time()) }}"
                                                                target="_blank">
                                                                <img src="{{ $logo . (isset($favicon) && !empty($favicon) ? $company_ficon : 'favicon.png' . '?timestemp=' . time()) }}"
                                                                    width="40px" class="img_setting"
                                                                    id="blah2"></a>
                                                        </div>
                                                        <div class="choose-files mt-5">
                                                            <label for="favicon"
                                                                class="form-label choose-files bg-primary ">
                                                                <i class="ti ti-upload px-1"></i>{{ __('Select Image') }}
                                                            </label>
                                                            <input type="file" name="favicon" id="favicon"
                                                                class="custom-input-file d-none"
                                                                onchange="document.getElementById('blah2').src = window.URL.createObjectURL(this.files[0])">
                                                        </div>
                                                        @error('favicon')
                                                            <div class="row">
                                                                <span class="invalid-logo" role="alert">
                                                                    <strong class="text-danger">{{ $message }}</strong>
                                                                </span>
                                                            </div>
                                                        @enderror
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            @error('logo')
                                                <div class="row">
                                                    <span class="invalid-logo" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                </div>
                                            @enderror
                                        </div>
                                        <div class="form-group col-md-4">
                                            {{ Form::label('title_text', __('Title Text'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('title_text', null, ['class' => 'form-control', 'placeholder' => __('Title Text')]) }}
                                            @error('title_text')
                                                <span class="invalid-title_text" role="alert">
                                                    <strong class="text-danger">{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        @if (\Auth::user()->type == 'company')
                                            <div class="form-group col-md-4">
                                                {{ Form::label('footer_text', __('Footer Text'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('footer_text', null, ['class' => 'form-control', 'placeholder' => __('Footer Text')]) }}
                                                @error('footer_text')
                                                    <span class="invalid-footer_text" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-4">
                                                {{ Form::label('', __('Default Languages'), ['class' => 'form-label text-dark']) }}
                                                <div class="changeLanguage js-single-select-custom">
                                                    @php
                                                        $user = Auth::user();
                                                        if ($user) {
                                                            $currantLang = $user->currentLanguage();
                                                            $languages = \App\Models\Utility::languages();
                                                        }

                                                    @endphp
                                                    <select name="default_language" id="default_language"
                                                        class="form-control js-single-select1" aria-hidden="true">
                                                        @if (isset($languages) && !empty($languages) && count($languages))
                                                            @foreach ($languages as $key => $language)
                                                                <option value="{{ $key }}"
                                                                    {{ $settings['default_language'] == $key ? 'selected' : '' }}>
                                                                    <span>{{ Str::title($language) }} </span>
                                                                </option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="form-group col-6 col-md-3">
                                            <div class="custom-control form-switch p-0">
                                                <label class="form-label text-dark"
                                                    for="display_landing_page">{{ __('Enable Landing Page') }}</label><br>
                                                <input type="checkbox" name="display_landing_page"
                                                    class="form-check-input" id="display_landing_page"
                                                    data-toggle="switchbutton"
                                                    {{ $settings['display_landing_page'] == 'on' ? 'checked="checked"' : '' }}
                                                    data-onstyle="primary">
                                            </div>
                                        </div>

                                        <div class="form-group col-6 col-md-3">
                                            <div class="custom-control form-switch p-0">
                                                <label class="form-label text-dark"
                                                    for="SITE_RTL">{{ __('Enable RTL') }}</label><br>
                                                <input type="checkbox" class="form-check-input"
                                                    data-toggle="switchbutton" data-onstyle="primary" name="SITE_RTL"
                                                    id="SITE_RTL"
                                                    {{ Utility::getValByName('SITE_RTL') == 'on' ? 'checked="checked"' : '' }}>
                                            </div>
                                        </div>
                                        <!-- <div class="form-group col-6 col-md-3">
                                                            <div class="custom-control form-switch p-0">
                                                                <label class="form-label text-dark"
                                                                    for="SIGNUP">{{ __('Enable Sign-Up Page') }}</label><br>
                                                                <input type="checkbox" name="SIGNUP" class="form-check-input" id="SIGNUP"
                                                                    data-toggle="switchbutton"
                                                                    {{ $settings['SIGNUP'] == 'on' ? 'checked="checked"' : '' }}
                                                                    data-onstyle="primary">
                                                            </div>
                                                        </div> -->
                                        {{-- <div class="form-group col-12 GDPR_Cookie_Text">
                                            {{ Form::label('cookie_text', __('GDPR Cookie Text'), ['class' => 'form-label text-dark']) }}
                                            {!! Form::textarea('cookie_text', $settings['cookie_text'], ['class' => 'form-control', 'rows' => '4']) !!}
                                        </div> --}}
                                        <h4 class="small-title">{{ __('Theme Customizer') }}</h4>

                                        <div class="setting-card setting-logo-box p-3">
                                            <div class="row">
                                                <div class="col-lg-4 col-xl-4 col-md-4">
                                                    <h6 class="mt-2">
                                                        <i data-feather="credit-card"
                                                            class="me-2"></i>{{ __('Primary color settings') }}
                                                    </h6>
                                                    <hr class="my-2" />
                                                    <div class="color-wrp">
                                                        <div class="theme-color themes-color">
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-1' ? 'active_color' : '' }}"
                                                                data-value="theme-1"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-1"{{ $color == 'theme-1' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-2' ? 'active_color' : '' }}"
                                                                data-value="theme-2"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-2"{{ $color == 'theme-2' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-3' ? 'active_color' : '' }}"
                                                                data-value="theme-3"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-3"{{ $color == 'theme-3' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-4' ? 'active_color' : '' }}"
                                                                data-value="theme-4"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-4"{{ $color == 'theme-4' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-5' ? 'active_color' : '' }}"
                                                                data-value="theme-5"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-5"{{ $color == 'theme-5' ? 'checked' : '' }}>
                                                            <br>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-6' ? 'active_color' : '' }}"
                                                                data-value="theme-6"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-6"{{ $color == 'theme-6' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-7' ? 'active_color' : '' }}"
                                                                data-value="theme-7"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-7"{{ $color == 'theme-7' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-8' ? 'active_color' : '' }}"
                                                                data-value="theme-8"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-8"{{ $color == 'theme-8' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-9' ? 'active_color' : '' }}"
                                                                data-value="theme-9"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-9"{{ $color == 'theme-9' ? 'checked' : '' }}>
                                                            <a href="#!"
                                                                class="themes-color-change {{ $color == 'theme-10' ? 'active_color' : '' }}"
                                                                data-value="theme-10"></a>
                                                            <input type="radio" class="theme_color d-none"
                                                                name="color"
                                                                value="theme-10"{{ $color == 'theme-10' ? 'checked' : '' }}>
                                                        </div>
                                                        <div class="color-picker-wrp ">
                                                            <input type="color" value="{{ $color ? $color : '' }}"
                                                                class="colorPicker {{ isset($flag) && $flag == 'true' ? 'active_color' : '' }}"
                                                                name="custom_color" id="color-picker">
                                                            <input type='hidden' name="color_flag"
                                                                value={{ isset($flag) && $flag == 'true' ? 'true' : 'false' }}>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-xl-4 col-md-4">
                                                    <h6 class="mt-2">
                                                        <i data-feather="layout"
                                                            class="me-2"></i>{{ __('Sidebar settings') }}
                                                    </h6>
                                                    <hr class="my-2" />
                                                    <div class="form-check form-switch">
                                                        <input type="checkbox" class="form-check-input"
                                                            id="cust-theme-bg" name="cust_theme_bg"
                                                            {{ !empty($settings['cust_theme_bg']) && $settings['cust_theme_bg'] == 'on' ? 'checked' : '' }} />
                                                        <label class="form-check-label f-w-600 pl-1 text-dark"
                                                            for="cust-theme-bg">{{ __('Transparent layout') }}</label>
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 col-xl-4 col-md-4">
                                                    <h6 class="mt-2">
                                                        <i data-feather="sun"
                                                            class="me-2"></i>{{ __('Layout settings') }}
                                                    </h6>
                                                    <hr class="my-2" />
                                                    <div class="form-check form-switch mt-2">
                                                        <input type="checkbox" class="form-check-input"
                                                            id="cust-darklayout"
                                                            name="cust_darklayout"{{ !empty($settings['cust_darklayout']) && $settings['cust_darklayout'] == 'on' ? 'checked' : '' }} />
                                                        <label class="form-check-label f-w-600 pl-1 text-dark"
                                                            for="cust-darklayout">{{ __('Dark Layout') }}</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <hr>
                                        <div class="form-group col-md-6">
                                            {{ Form::label('footer_link_1', __('Footer Link Title 1'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('footer_link_1', null, ['class' => 'form-control', 'placeholder' => __('Enter Footer Link Title 1')]) }}
                                        </div>
                                        <div class="form-group col-md-6">
                                            {{ Form::label('footer_value_1', __('Footer Link href 1'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('footer_value_1', null, ['class' => 'form-control', 'placeholder' => __('Enter Footer Link 1')]) }}
                                        </div>
                                        <div class="form-group col-md-6">
                                            {{ Form::label('footer_link_2', __('Footer Link Title 2'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('footer_link_2', null, ['class' => 'form-control', 'placeholder' => __('Enter Footer Link Title 2')]) }}
                                        </div>
                                        <div class="form-group col-md-6">
                                            {{ Form::label('footer_value_2', __('Footer Link href 2'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('footer_value_2', null, ['class' => 'form-control', 'placeholder' => __('Enter Footer Link 2')]) }}
                                        </div>
                                        <div class="form-group col-md-6">
                                            {{ Form::label('footer_link_3', __('Footer Link Title 3'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('footer_link_3', null, ['class' => 'form-control', 'placeholder' => __('Enter Footer Link Title 3')]) }}
                                        </div>
                                        <div class="form-group col-md-6">
                                            {{ Form::label('footer_value_3', __('Footer Link href 3'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('footer_value_3', null, ['class' => 'form-control', 'placeholder' => __('Enter Footer Link 3')]) }}
                                        </div>
                                        <div class="card-footer text-end py-0 pe-2 border-0">
                                            {{ Form::submit(__('Save Changes'), ['class' => 'btn  btn-primary']) }}
                                        </div>
                                    </div>
                                    {{ Form::close() }}
                                </div>
                            </div>

                            <!--Company_setting-->
                            <div id="Company_setting" class="card text-white">
                                <div class="card-header">
                                    <h5>{{ __('Company Settings') }}</h5>
                                    <small class="text-muted">{{ __('Edit your company details') }}</small>
                                </div>
                                <div class="card-body">
                                    {{ Form::model($settings, ['route' => ['setting.CompanySettings', $profile->id], 'method' => 'PUT', 'class' => 'permission_table_information', 'enctype' => 'multipart/form-data']) }}
                                    {{ Form::hidden('form_type', 'site_setting') }}
                                    <div class="row">
                                        <div class="form-group col-md-4">
                                            {{ Form::label('contract_prefix', __('Contract Prefix'), ['class' => 'form-label text-dark']) }}
                                            {{ Form::text('contract_prefix', null, ['class' => 'form-control']) }}
                                            @error('contract_prefix')
                                                <span class="invalid-contract_prefix" role="alert">
                                                    <strong class="text-danger">{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        <div class="form-group col-md-4">
                                            {{ Form::label('', __('Company Start Time'), ['class' => 'form-label text-dark h6']) }}
                                            {!! Form::time('company_start_time', null, ['class' => 'form-control'], \Carbon\Carbon::parse()->format('h')) !!}
                                        </div>

                                        <div class="form-group col-md-4">
                                            {{ Form::label('', __('Company End Time'), ['class' => 'form-label text-dark h6']) }}
                                            {!! Form::time('company_end_time', null, ['class' => 'form-control'], \Carbon\Carbon::parse()->format('h')) !!}
                                        </div>

                                        <div class="form-group col-md-6">
                                            {{ Form::label('', __('Timezone'), ['class' => 'form-label text-dark h6']) }}
                                            <select type="text" name="timezone" class="form-control select2"
                                                id="timezone">
                                                <option value="">{{ __('Select Timezone') }}</option>
                                                @if (!empty($timezones))
                                                    @foreach ($timezones as $k => $timezone)
                                                        <option value="{{ $k }}"
                                                            {{ env('TIMEZONE') == $k ? 'selected' : '' }}>
                                                            {{ $timezone }}
                                                        </option>
                                                    @endforeach
                                                @endif
                                            </select>
                                            @error('timezone')
                                                <span class="invalid-timezone" role="alert">
                                                    <small class="text-danger">{{ $message }}</small>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="form-group col-6 col-md-3">
                                            <div class="custom-control form-switch p-0">
                                                <label class="form-label text-dark"
                                                    for="ip_restrict">{{ __('Ip Restrict') }}</label><br>
                                                <input type="checkbox" class="form-check-input"
                                                    data-toggle="switchbutton" data-onstyle="primary" name="ip_restrict"
                                                    id="ip_restrict"
                                                    {{ $settings['ip_restrict'] == 'on' ? 'checked="checked"' : '' }}>
                                            </div>
                                        </div>

                                        <div class="card-footer text-end border-0 p-0">
                                            {{ Form::submit(__('Save Changes'), ['class' => 'btn btn-primary']) }}
                                        </div>
                                        {{ Form::close() }}
                                    </div>
                                </div>
                            </div>

                            <!--Email_Setting-->
                            <div id="Email_Setting" class="card">
                                <div class="card-header">
                                    <h5>{{ __('Email     Settings') }}</h5>
                                    <small class="text-muted">{{ __('Edit email settings') }}</small>
                                </div>
                                <div class="">
                                    {{ Form::model($settings, ['route' => ['email.setting'], 'method' => 'POST', 'class' => 'permission_table_information', 'enctype' => 'multipart/form-data']) }}
                                    {{ Form::hidden('form_type', 'email_setting') }}
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_driver', __('Mail Driver'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('mail_driver', $settings['mail_driver'], ['class' => 'form-control', 'placeholder' => __('Enter Mail Driver')]) }}
                                                @error('mail_driver')
                                                    <span class="invalid-mail_driver" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_host', __('Mail Host'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('mail_host', $settings['mail_host'], ['class' => 'form-control ', 'placeholder' => __('Enter Mail Driver')]) }}
                                                @error('mail_host')
                                                    <span class="invalid-mail_driver" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_port', __('Mail Port'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('mail_port', $settings['mail_port'], ['class' => 'form-control', 'placeholder' => __('Enter Mail Port')]) }}
                                                @error('mail_port')
                                                    <span class="invalid-mail_port" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_username', __('Mail Username'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('mail_username', $settings['mail_username'], ['class' => 'form-control', 'placeholder' => __('Enter Mail Username')]) }}
                                                @error('mail_username')
                                                    <span class="invalid-mail_username" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_password', __('Mail Password'), ['class' => 'form-label text-dark']) }}
                                                <input class="form-control"
                                                    placeholder="{{ __('Enter Mail Password') }}" name="mail_password"
                                                    type="text" value="{{ $settings['mail_password'] }}"
                                                    id="mail_password">
                                                @error('mail_password')
                                                    <span class="invalid-mail_password" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_encryption', __('Mail Encryption'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('mail_encryption', $settings['mail_encryption'], ['class' => 'form-control', 'placeholder' => __('Enter Mail Encryption')]) }}
                                                @error('mail_encryption')
                                                    <span class="invalid-mail_encryption" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_from_address', __('Mail From Address'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('mail_from_address', $settings['mail_from_address'], ['class' => 'form-control', 'placeholder' => __('Enter Mail From Address')]) }}
                                                @error('mail_from_address')
                                                    <span class="invalid-mail_from_address" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('mail_from_name', __('Mail From Name'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('mail_from_name', $settings['mail_from_name'], ['class' => 'form-control', 'placeholder' => __('Enter Mail From Name')]) }}
                                                @error('mail_from_name')
                                                    <span class="invalid-mail_from_name" role="alert">
                                                        <strong class="text-danger">{{ $message }}</strong>
                                                    </span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <div class="row">
                                            <div class="form-group col-6 mb-0">
                                                {{-- <a href="#" data-url="{{ route('test.mail') }}" data-ajax-popup="true"
                                                    data-title="{{ __('Send Test Mail') }}" class="btn btn-primary">
                                                    {{ __('Send Test Mail') }}
                                                </a> --}}
                                                <a href="#" data-url="{{ route('test.mail') }}"
                                                    data-title="{{ __('Send Test Mail') }}"
                                                    class="btn btn-primary btn-submit text-white send_email">
                                                    {{ __('Send Test Mail') }}
                                                </a>
                                            </div>
                                            <div class="form-group col-6 text-end mb-0">
                                                {{ Form::submit(__('Save Changes'), ['class' => 'btn btn-primary']) }}
                                            </div>
                                        </div>
                                    </div>
                                    {{ Form::close() }}
                                </div>
                            </div>

                            <!--IP_Setting-->
                            <div class="" id="ip-restriction-settings">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between">
                                        <h5>{{ __('IP Restriction Settings') }}</h5>
                                        <div class="btn btn-sm btn-primary btn-icon m-1">
                                            <a href="#" data-bs-toggle="tooltip" data-bs-placement="top"
                                                title="{{ __('Create New IP') }}" data-url="{{ route('create.ip') }}"
                                                data-size="md" data-ajax-popup="true"
                                                data-title="{{ __('Create New IP') }}">
                                                <i class="ti ti-plus text-white"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="card-body table-border-style ">
                                        <div class="table-responsive">
                                            <table class="table" id="pc-dt-simple">
                                                <thead>
                                                    <tr>
                                                        <th class="w-75"> {{ __('IP') }}</th>
                                                        <th width="200px"> {{ 'Action' }}</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($ips as $ip)
                                                        <tr class="Action">
                                                            <td class="sorting_1">{{ $ip->ip }}</td>
                                                            <td class="">
                                                                <div class="action-btn bg-info ms-2">
                                                                    <a class="mx-3 btn btn-sm  align-items-center"
                                                                        data-url="{{ route('edit.ip', $ip->id) }}"
                                                                        data-size="md" data-ajax-popup="true"
                                                                        data-title="{{ __('Edit IP') }}"
                                                                        data-bs-toggle="tooltip"
                                                                        data-bs-original-title="{{ __('Edit') }}"
                                                                        data-bs-placement="top" class="edit-icon"
                                                                        data-original-title="{{ __('Edit') }}">
                                                                        <i class="ti ti-pencil text-white"></i>
                                                                    </a>
                                                                </div>
                                                                <div class="action-btn bg-danger ms-2"
                                                                    data-bs-toggle="tooltip" data-bs-placement="top"
                                                                    title="{{ __('Delete') }}">
                                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['destroy.ip', $ip->id]]) !!}
                                                                    <a href="#!"
                                                                        class="mx-3 btn btn-sm show_confirm">
                                                                        <i class="ti ti-trash text-white"></i>
                                                                    </a>
                                                                    {!! Form::close() !!}
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!--Zoom_Setting-->
                            <div id="Zoom_Setting" class="card text-white">
                                <div class="card-header">
                                    <h5>{{ __('Zoom Settings') }}</h5>
                                    <small class="text-muted">{{ __('Edit your zoom meetings') }}</small>
                                </div>
                                <div class="card-body">

                                    {{ Form::open(['url' => route('setting.ZoomSettings', $profile->id), 'enctype' => 'multipart/form-data']) }}
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label class="form-label h6">{{ __('Zoom Account ID') }}</label>
                                                <input type="text" name="zoom_account_id" class="form-control"
                                                    placeholder="Enter Zoom Account ID"
                                                    value="{{ !empty($settings['zoom_account_id']) ? $settings['zoom_account_id'] : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <label class="form-label h6">{{ __('Zoom Client ID') }}</label>
                                            <input type="text" name="zoom_client_id" class="form-control"
                                                placeholder="Enter Zoom Client ID"
                                                value="{{ !empty($settings['zoom_client_id']) ? $settings['zoom_client_id'] : '' }}">
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label class="form-label h6">{{ __('Zoom Client Secret Key') }}</label>
                                                <input type="text" name="zoom_client_secret_key" class="form-control"
                                                    placeholder="Enter Zoom Client Secret Key"
                                                    value="{{ !empty($settings['zoom_client_secret_key']) ? $settings['zoom_client_secret_key'] : '' }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="card-footer border-0 p-0 text-end">

                                        {{ Form::submit(__('Save Changes'), ['class' => 'btn btn-primary']) }}
                                    </div>
                                    {{ Form::close() }}
                                </div>
                            </div>
                            <!--Slack_Setting-->
                            <div id="Slack_Setting" class="card text-white">
                                <div class="card-header">
                                    <h5>{{ __('Slack Settings') }}</h5>
                                    <small class="text-muted">{{ __('Edit your Slack settings') }}</small>
                                </div>
                                <div class="card-body">

                                    {{ Form::open(['route' => 'slack.setting', 'id' => 'slack-setting', 'method' => 'post', 'class' => 'd-contents']) }}
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h4 class="small-title">{{ __('Slack Webhook URL') }}</h4>
                                            <div class="col-md-8">
                                                {{ Form::text('slack_webhook', isset($settings['slack_webhook']) ? $settings['slack_webhook'] : '', ['class' => 'form-control w-100', 'placeholder' => __('Enter Slack Webhook URL'), 'required' => 'required']) }}
                                            </div>
                                        </div>

                                        <div class="col-md-12 mt-4 mb-2">
                                            <h4 class="small-title">{{ __('Module Settings') }}</h4>
                                        </div>
                                        <div class="col-md-4">
                                            <ul class="list-group">
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('New Rotas') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('rotas_notification', '1', isset($settings['rotas_notification']) && $settings['rotas_notification'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'rotas_notification']) }}
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('Cancel Rotas') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('rotas_cancle_notificaation', '1', isset($settings['rotas_cancle_notificaation']) && $settings['rotas_cancle_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'rotas_cancle_notificaation']) }}
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="col-md-4">
                                            <ul class="list-group">
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('Rotas Time Change') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('rotas_time_change_notificaation', '1', isset($settings['rotas_time_change_notificaation']) && $settings['rotas_time_change_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'rotas_time_change_notificaation']) }}
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <span class="text-dark"> {{ __('Days Off') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('days_off_notificaation', '1', isset($settings['days_off_notificaation']) && $settings['days_off_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'days_off_notificaation']) }}
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="col-md-4">
                                            <ul class="list-group">
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('New Availability') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('availability_create_notificaation', '1', isset($settings['availability_create_notificaation']) && $settings['availability_create_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'availability_create_notificaation']) }}
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="card-footer text-end border-0 p-0">
                                        {{ Form::submit(__('Save Changes'), ['class' => 'btn btn-primary']) }}
                                    </div>
                                    {{ Form::close() }}
                                </div>
                            </div>

                            <!--Telegram_Setting-->
                            <div id="Telegram_Setting" class="card text-white">
                                <div class="card-header">
                                    <h5>{{ __('Telegram Settings') }}</h5>
                                    <small class="text-muted">{{ __('Edit your Telegram settings') }}</small>
                                </div>
                                <div class="card-body">

                                    {{ Form::open(['route' => 'telegram.setting', 'id' => 'telegram-setting', 'method' => 'post', 'class' => 'd-contents']) }}
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group">
                                                {{ Form::label('telegrambot', __('Telegram Access Token'), ['class' => 'form-label h6']) }}
                                                {{ Form::text('telegrambot', isset($settings['telegrambot']) ? $settings['telegrambot'] : '', ['class' => 'form-control active telegrambot', 'placeholder' => '1234567890:AAbbbbccccddddxvGENZCi8Hd4B15M8xHV0']) }}
                                                <p class="text-dark">{{ __('Get Chat ID') }} :
                                                    https://api.telegram.org/bot-TOKEN-/getUpdates</p>
                                                @if ($errors->has('telegrambot'))
                                                    <span class="invalid-feedback d-block">
                                                        {{ $errors->first('telegrambot') }}
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                {{ Form::label('telegramchatid', __('Telegram Chat Id'), ['class' => 'form-label h6']) }}
                                                {{ Form::text('telegramchatid', isset($settings['telegramchatid']) ? $settings['telegramchatid'] : '', ['class' => 'form-control active telegramchatid', 'placeholder' => '123456789']) }}
                                                @if ($errors->has('telegramchatid'))
                                                    <span class="invalid-feedback d-block">
                                                        {{ $errors->first('telegramchatid') }}
                                                    </span>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="col-md-12 mt-4 mb-2">
                                            <h4 class="small-title">{{ __('Module Settings') }}</h4>
                                        </div>
                                        <div class="col-md-4">
                                            <ul class="list-group">
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('New Rotas') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('telegram_rotas_notification', '1', isset($settings['telegram_rotas_notification']) && $settings['telegram_rotas_notification'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'telegram_rotas_notification']) }}
                                                        <label class="custom-control-label"
                                                            for="telegram_rotas_notification"></label>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('Cancel Rotas') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('telegram_rotas_cancle_notificaation', '1', isset($settings['telegram_rotas_cancle_notificaation']) && $settings['telegram_rotas_cancle_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'telegram_rotas_cancle_notificaation']) }}
                                                        <label class="custom-control-label"
                                                            for="telegram_rotas_cancle_notificaation"></label>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="col-md-4">
                                            <ul class="list-group">
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('Rotas Time Change') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('telegram_rotas_time_change_notificaation', '1', isset($settings['telegram_rotas_time_change_notificaation']) && $settings['telegram_rotas_time_change_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'telegram_rotas_time_change_notificaation']) }}
                                                        <label class="custom-control-label"
                                                            for="telegram_rotas_time_change_notificaation"></label>
                                                    </div>
                                                </li>
                                                <li class="list-group-item">
                                                    <span class="text-dark"> {{ __('Days Off') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('telegram_days_off_notificaation', '1', isset($settings['telegram_days_off_notificaation']) && $settings['telegram_days_off_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'telegram_days_off_notificaation']) }}
                                                        <label class="custom-control-label"
                                                            for="telegram_days_off_notificaation"></label>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="col-md-4">
                                            <ul class="list-group">
                                                <li class="list-group-item">
                                                    <span class="text-dark">{{ __('New Availability') }}</span>
                                                    <div class="form-check form-switch float-end">
                                                        {{ Form::checkbox('telegram_availability_create_notificaation', '1', isset($settings['telegram_availability_create_notificaation']) && $settings['telegram_availability_create_notificaation'] == '1' ? 'checked' : '', ['class' => 'form-check-input input-primary', 'id' => 'telegram_availability_create_notificaation']) }}
                                                        <label class="custom-control-label"
                                                            for="telegram_availability_create_notificaation"></label>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="card-footer text-end border-0 p-0">
                                        {{ Form::submit(__('Save Changes'), ['class' => 'btn btn-primary']) }}
                                    </div>
                                    {{ Form::close() }}
                                </div>
                            </div>

                            <!--Pusher_Setting-->
                            <div id="Pusher_Setting" class="card">
                                {{ Form::model($settings, ['route' => ['pusher.setting'], 'method' => 'POST', 'class' => 'permission_table_information', 'enctype' => 'multipart/form-data']) }}
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-8 col-md-8 col-sm-8">
                                            <h5 class="">{{ __('Pusher Settings') }}</h5>
                                            <small
                                                class="text-secondary font-weight-bold">{{ __('Edit Pusher settings') }}</small>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 text-end">
                                            <input type="hidden" name="is_mercado_enabled" value="off">
                                            <input type="checkbox" name="enable_chat" id="enable_chat"
                                                data-toggle="switchbutton" data-onstyle="primary"
                                                {{ !empty($settings['enable_chat']) && $settings['enable_chat'] == 'on' ? 'checked="checked"' : '' }}>
                                            <label class="custom-label form-label" for="enable_chat"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="form-group col-md-6">
                                                {{ Form::label('', __('Pusher App Id'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('pusher_app_id', $settings['pusher_app_id'], ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Pusher App Id')]) }}
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('', __('Pusher App Key'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('pusher_app_key', $settings['pusher_app_key'], ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Pusher App Key')]) }}
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('', __('Pusher App Secret'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('pusher_app_secret', $settings['pusher_app_secret'], ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Pusher App Secret')]) }}
                                            </div>
                                            <div class="form-group col-md-6">
                                                {{ Form::label('', __('Pusher App Cluster'), ['class' => 'form-label text-dark']) }}
                                                {{ Form::text('pusher_app_cluster', $settings['pusher_app_cluster'], ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('Pusher App Cluster')]) }}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <div class="col-lg-12  text-end">
                                            <input type="submit" value="{{ __('Save Changes') }}"
                                                class="btn btn-primary">
                                        </div>
                                    </div>
                                </div>
                                {{ Form::close() }}
                            </div>

                            <!--ReCaptcha_Setting-->
                            <div id="ReCaptcha_Setting" class="card">
                                <form method="POST" action="{{ route('recaptcha.settings.store') }}"
                                    accept-charset="UTF-8">
                                    @csrf
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-lg-8 col-md-8 col-sm-8">
                                                <h5>{{ __('ReCaptcha Settings') }}</h5>
                                                <small class="text-muted"><a
                                                        href="https://phppot.com/php/how-to-get-google-recaptcha-site-and-secret-key/"
                                                        target="_blank" class="text-blue">
                                                        <small>({{ __('How to Get Google reCaptcha Site and Secret key') }})</small>
                                                    </a> </small>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-4 text-end">
                                                <input type="checkbox" name="recaptcha_module" id="recaptcha_module"
                                                    data-toggle="switchbutton" value="yes" data-onstyle="primary"
                                                    {{ $settings['recaptcha_module'] == 'yes' ? 'checked="checked"' : '' }}>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="">
                                        <div class="card-body">
                                            <div class="col-md-6">
                                                <div class="form-group col switch-width">
                                                    <label for="google_recaptcha_version" class=" col-form-label">{{__('Google Recaptcha Version')}}</label>

                                                    <select id="google_recaptcha_version" class="form-control choices" searchEnabled="true" name="google_recaptcha_version">
                                                        <option value="v2" {{  isset($settings['google_recaptcha_version']) && $settings['google_recaptcha_version'] == 'v2' ? 'selected' : '' }}>v2</option>
                                                        <option value="v3" {{ isset($settings['google_recaptcha_version']) && $settings['google_recaptcha_version'] == 'v3' ? 'selected' : '' }} >v3</option></select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-lg-6 col-md-6 col-sm-6 form-group">
                                                    <label for="google_recaptcha_key"
                                                        class="form-label text-dark">{{ __('Google Recaptcha Key') }}</label>
                                                    <input class="form-control"
                                                        placeholder="{{ __('Enter Google Recaptcha Key') }}"
                                                        name="google_recaptcha_key" type="text"
                                                        value="{{ isset($settings['google_recaptcha_version']) && $settings['google_recaptcha_version'] == 'v2' ? $setting['google_recaptcha_key'] : $setting['google_recaptcha_key_3'] }}"
                                                        id="google_recaptcha_key">
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-sm-6 form-group">
                                                    <label for="google_recaptcha_secret"
                                                        class="form-label text-dark">{{ __('Google Recaptcha Secret') }}</label>
                                                    <input class="form-control "
                                                        placeholder="{{ __('Enter Google Recaptcha Secret') }}"
                                                        name="google_recaptcha_secret" type="text"
                                                        value="{{ isset($settings['google_recaptcha_version']) && $settings['google_recaptcha_version'] == 'v2' ? $setting['google_recaptcha_secret'] : $setting['google_recaptcha_secret_3'] }}"
                                                        id="google_recaptcha_secret">
                                                </div>
                                            </div>
                                            <div class="col-lg-12  text-end">
                                                <input type="submit" value="{{ __('Save Changes') }}"
                                                    class="btn btn-primary">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                            <!--Storage_Setting-->
                            <div id="Storage_Setting" class="card mb-3">
                                {{ Form::open(['route' => 'storage.setting.store', 'enctype' => 'multipart/form-data']) }}
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-10 col-md-10 col-sm-10">
                                            <h5 class="">{{ __('Storage Settings') }}</h5>
                                            <small class="text-muted">{{ __('Edit storage settings') }}</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex">
                                        <div class="pe-2">

                                            <input type="radio" class="btn-check" name="storage_setting"
                                                id="local-outlined" autocomplete="off"
                                                {{ $settings['storage_setting'] == 'local' ? 'checked' : '' }}
                                                value="local" checked>
                                            <label class="btn btn-outline-primary"
                                                for="local-outlined">{{ __('Local') }}</label>
                                        </div>
                                        <div class="pe-2">
                                            <input type="radio" class="btn-check" name="storage_setting"
                                                id="s3-outlined" autocomplete="off"
                                                {{ $settings['storage_setting'] == 's3' ? 'checked' : '' }}
                                                value="s3">
                                            <label class="btn btn-outline-primary" for="s3-outlined">
                                                {{ __('AWS S3') }}</label>
                                        </div>

                                        <div class="pe-2">
                                            <input type="radio" class="btn-check" name="storage_setting"
                                                id="wasabi-outlined" autocomplete="off"
                                                {{ $settings['storage_setting'] == 'wasabi' ? 'checked' : '' }}
                                                value="wasabi">
                                            <label class="btn btn-outline-primary"
                                                for="wasabi-outlined">{{ __('Wasabi') }}</label>
                                        </div>
                                    </div>

                                    <div class="local-setting row">
                                        {{-- <h4 class="small-title">{{ __('Local Settings') }}</h4> --}}
                                        <div class="form-group col-8 switch-width">
                                            {{ Form::label('local_storage_validation', __('Only Upload Files'), ['class' => ' form-label']) }}
                                            <select name="local_storage_validation[]" class="form-control multi-select"
                                                id="local_storage_validation" multiple>
                                                @foreach ($file_type as $f)
                                                    <option @if (in_array($f, $local_storage_validations)) selected @endif>
                                                        {{ $f }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="form-group">
                                                <label class="form-label"
                                                    for="local_storage_max_upload_size">{{ __('Max upload size ( In KB)') }}</label>
                                                <input type="number" name="local_storage_max_upload_size"
                                                    class="form-control"
                                                    value="{{ !isset($settings['local_storage_max_upload_size']) || is_null($settings['local_storage_max_upload_size']) ? '' : $settings['local_storage_max_upload_size'] }}"
                                                    placeholder="{{ __('Max upload size') }}">
                                            </div>
                                        </div>
                                    </div>

                                    <div
                                        class="s3-setting row {{ $settings['storage_setting'] == 's3' ? ' ' : 'd-none' }}">

                                        <div class=" row ">
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="s3_key">{{ __('S3 Key') }}</label>
                                                    <input type="text" name="s3_key" class="form-control"
                                                        value="{{ !isset($settings['s3_key']) || is_null($settings['s3_key']) ? '' : $settings['s3_key'] }}"
                                                        placeholder="{{ __('S3 Key') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_secret">{{ __('S3 Secret') }}</label>
                                                    <input type="text" name="s3_secret" class="form-control"
                                                        value="{{ !isset($settings['s3_secret']) || is_null($settings['s3_secret']) ? '' : $settings['s3_secret'] }}"
                                                        placeholder="{{ __('S3 Secret') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_region">{{ __('S3 Region') }}</label>
                                                    <input type="text" name="s3_region" class="form-control"
                                                        value="{{ !isset($settings['s3_region']) || is_null($settings['s3_region']) ? '' : $settings['s3_region'] }}"
                                                        placeholder="{{ __('S3 Region') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_bucket">{{ __('S3 Bucket') }}</label>
                                                    <input type="text" name="s3_bucket" class="form-control"
                                                        value="{{ !isset($settings['s3_bucket']) || is_null($settings['s3_bucket']) ? '' : $settings['s3_bucket'] }}"
                                                        placeholder="{{ __('S3 Bucket') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label" for="s3_url">{{ __('S3 URL') }}</label>
                                                    <input type="text" name="s3_url" class="form-control"
                                                        value="{{ !isset($settings['s3_url']) || is_null($settings['s3_url']) ? '' : $settings['s3_url'] }}"
                                                        placeholder="{{ __('S3 URL') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_endpoint">{{ __('S3 Endpoint') }}</label>
                                                    <input type="text" name="s3_endpoint" class="form-control"
                                                        value="{{ !isset($settings['s3_endpoint']) || is_null($settings['s3_endpoint']) ? '' : $settings['s3_endpoint'] }}"
                                                        placeholder="{{ __('S3 Endpoint') }}">
                                                </div>
                                            </div>
                                            <div class="form-group col-8 switch-width">
                                                {{ Form::label('s3_storage_validation', __('Only Upload Files'), ['class' => ' form-label']) }}
                                                {{-- {{ Form::label('s3_storage_validation', __('Only Upload Files'), ['class' => 'form-label']) }} --}}
                                                <select name="s3_storage_validation[]" class="form-control multi-select"
                                                    id="s3_storage_validation" multiple>
                                                    @foreach ($file_type as $f)
                                                        <option @if (in_array($f, $s3_storage_validations)) selected @endif>
                                                            {{ $f }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_max_upload_size">{{ __('Max upload size ( In KB)') }}</label>
                                                    <input type="number" name="s3_max_upload_size" class="form-control"
                                                        value="{{ !isset($settings['s3_max_upload_size']) || is_null($settings['s3_max_upload_size']) ? '' : $settings['s3_max_upload_size'] }}"
                                                        placeholder="{{ __('Max upload size') }}">
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div
                                        class="wasabi-setting row {{ $settings['storage_setting'] == 'wasabi' ? ' ' : 'd-none' }}">
                                        <div class=" row ">
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_key">{{ __('Wasabi Key') }}</label>
                                                    <input type="text" name="wasabi_key" class="form-control"
                                                        value="{{ !isset($settings['wasabi_key']) || is_null($settings['wasabi_key']) ? '' : $settings['wasabi_key'] }}"
                                                        placeholder="{{ __('Wasabi Key') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_secret">{{ __('Wasabi Secret') }}</label>
                                                    <input type="text" name="wasabi_secret" class="form-control"
                                                        value="{{ !isset($settings['wasabi_secret']) || is_null($settings['wasabi_secret']) ? '' : $settings['wasabi_secret'] }}"
                                                        placeholder="{{ __('Wasabi Secret') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="s3_region">{{ __('Wasabi Region') }}</label>
                                                    <input type="text" name="wasabi_region" class="form-control"
                                                        value="{{ !isset($settings['wasabi_region']) || is_null($settings['wasabi_region']) ? '' : $settings['wasabi_region'] }}"
                                                        placeholder="{{ __('Wasabi Region') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="wasabi_bucket">{{ __('Wasabi Bucket') }}</label>
                                                    <input type="text" name="wasabi_bucket" class="form-control"
                                                        value="{{ !isset($settings['wasabi_bucket']) || is_null($settings['wasabi_bucket']) ? '' : $settings['wasabi_bucket'] }}"
                                                        placeholder="{{ __('Wasabi Bucket') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="wasabi_url">{{ __('Wasabi URL') }}</label>
                                                    <input type="text" name="wasabi_url" class="form-control"
                                                        value="{{ !isset($settings['wasabi_url']) || is_null($settings['wasabi_url']) ? '' : $settings['wasabi_url'] }}"
                                                        placeholder="{{ __('Wasabi URL') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-6">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="wasabi_root">{{ __('Wasabi Root') }}</label>
                                                    <input type="text" name="wasabi_root" class="form-control"
                                                        value="{{ !isset($settings['wasabi_root']) || is_null($settings['wasabi_root']) ? '' : $settings['wasabi_root'] }}"
                                                        placeholder="{{ __('Wasabi Root') }}">
                                                </div>
                                            </div>
                                            <div class="form-group col-8 switch-width">
                                                {{ Form::label('wasabi_storage_validation', __('Only Upload Files'), ['class' => 'form-label']) }}

                                                <select name="wasabi_storage_validation[]"
                                                    class="form-control multi-select" id="wasabi_storage_validation"
                                                    multiple>
                                                    @foreach ($file_type as $f)
                                                        <option @if (in_array($f, $wasabi_storage_validations)) selected @endif>
                                                            {{ $f }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-lg-4">
                                                <div class="form-group">
                                                    <label class="form-label"
                                                        for="wasabi_root">{{ __('Max upload size ( In KB)') }}</label>
                                                    <input type="number" name="wasabi_max_upload_size"
                                                        class="form-control"
                                                        value="{{ !isset($settings['wasabi_max_upload_size']) || is_null($settings['wasabi_max_upload_size']) ? '' : $settings['wasabi_max_upload_size'] }}"
                                                        placeholder="{{ __('Max upload size') }}">
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="col-lg-12  text-end">
                                        <input type="submit" value="{{ __('Save Changes') }}" class="btn btn-primary">
                                    </div>
                                </div>
                                {{ Form::close() }}
                            </div>

                            <!--Google_Setting-->
                            <div id="Google_Setting" class="card">
                                {{ Form::open(['url' => route('setting.GoogleCalendaSetting', $profile->id), 'enctype' => 'multipart/form-data']) }}
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-8 col-md-8 col-sm-8">
                                            <h5 class="">{{ __('Google Calendar Settings') }}</h5>
                                            <small
                                                class="text-secondary font-weight-bold">{{ __('Edit your Google Calendar Settings') }}</small>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 text-end">
                                            <input type="hidden" name="is_mercado_enabled" value="off">
                                            <input type="checkbox" name="Google_Calendar" id="Google_Calendar"
                                                data-toggle="switchbutton" data-onstyle="primary"
                                                {{ isset($settings['Google_Calendar']) && $settings['Google_Calendar'] == 'on' ? 'checked="checked"' : '' }}>
                                            <label class="custom-label form-label" for="Google_Calendar"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group">
                                                <label class="form-label h6">{{ __('Google calendar id') }}</label>
                                                <input type="text" name="google_clender_id" class="form-control"
                                                    placeholder="Enter Google calendar id"
                                                    value="{{ !empty($settings['google_clender_id']) ? $settings['google_clender_id'] : '' }}">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <label class="form-label h6">{{ __('Google calendar json file') }}</label>
                                            <input type="file" name="google_calender_json_file" id="json_file"
                                                class="form-control custom-input-file"
                                                placeholder="Enter Google calendar json file"
                                                value="{{ !empty($settings['google_calender_json_file']) ? $settings['google_calender_json_file'] : '' }}">
                                        </div>
                                    </div>

                                    <div class="card-footer border-0 p-0 text-end">
                                        {{ Form::submit(__('Save Changes'), ['class' => 'btn btn-primary']) }}
                                    </div>
                                </div>
                                {{ Form::close() }}
                            </div>

                            <!--Seo Setting-->
                            <div id="Seo_Setting" class="card">
                                {{ Form::model($settings, ['route' => ['seo.setting.store'], 'method' => 'POST', 'class' => 'permission_table_information', 'enctype' => 'multipart/form-data']) }}
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-10 col-md-10 col-sm-10">
                                            <h5 class="">{{ __('SEO settings') }}</h5>
                                            <small
                                                class="text-secondary font-weight-bold">{{ __('Edit SEO settings') }}</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row mt-6">
                                        @if (\Utility::enable_chatgpt())
                                            <div class="text-end">
                                                <a href="#" class="btn btn-print-invoice btn-primary btn-icon"
                                                    data-size="lg" data-ajax-popup-over="true"
                                                    data-url="{{ route('generate', ['seo']) }}" data-bs-toggle="tooltip"
                                                    data-bs-placement="top" title="{{ __('Generate') }}"
                                                    data-title="{{ __('Generate product Name') }}">
                                                    <i class="fas fa-robot"></i>{{ __(' Generate with AI') }}
                                                </a>
                                            </div>
                                        @endif
                                        <div class="col-lg-6">
                                            <div class="form-group">
                                                {{ Form::label('meta_keyword', __('Meta Keywords'), ['class' => 'form-label']) }}
                                                {{ Form::text('meta_keyword', null, ['class' => 'form-control', 'placeholder' => __('Meta Keywords')]) }}
                                            </div>
                                            <div class="form-group">
                                                {{ Form::label('meta_description', __('Meta Description'), ['class' => 'form-label']) }}
                                                {{ Form::textarea('meta_description', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('Meta Description')]) }}
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            {{ Form::label('meta_image', __('Meta Image'), ['class' => 'form-label']) }}
                                            <div class="form-group">
                                                <a href="{{ $meta_image . '/' . (isset($setting['meta_image']) && !empty($setting['meta_image']) ? $setting['meta_image'] : 'meta_image.png') }}"
                                                    target="_blank"> <img id="meta"
                                                        src="{{ $meta_image . '/' . (isset($setting['meta_image']) && !empty($setting['meta_image']) ? $setting['meta_image'] : 'meta_image.png') }}"
                                                        width="300px" class="img_setting"> </a>
                                            </div>
                                            <div class="form-group">
                                                <label for="meta_image" class="form-label choose-files bg-primary "><i
                                                        class="ti ti-upload px-1"></i>{{ __('Select Image') }}</label>
                                                <input type="file" name="meta_image" id="meta_image"
                                                    class="custom-input-file d-none"
                                                    onchange="document.getElementById('meta').src = window.URL.createObjectURL(this.files[0])">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="col-lg-12  text-end">
                                        <input type="submit" value="{{ __('Save Changes') }}" class="btn btn-primary">
                                    </div>
                                </div>
                                {{ Form::close() }}
                            </div>

                            <!--cache-->
                            <div id="Cache_Setting" class="card">
                                <div class="row justify-content-center">
                                    <div class="col-md-12">
                                        <div class="card-header">
                                            <div class="col-lg-10 col-md-10 col-sm-10">
                                                <h5 class="">{{ __('Cache Settings') }}</h5>
                                                <small class="text-secondary font-weight-bold">
                                                    {{ __('This is a page meant for more advanced users, simply ignore it if you don`t understand what cache is.') }}
                                                </small>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    {{ Form::label('', __('Current cache size'), ['class' => 'form-label']) }}
                                                    <div class="input-group search-form">
                                                        <input type="text"
                                                            value="{{ App\Models\Utility::GetCacheSize() }}"
                                                            class="form-control" readonly ="true">
                                                        <span
                                                            class="input-group-text bg-transparent">{{ __('MB') }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class=" text-end">
                                                <a href="{{ url('config-cache') }}"
                                                    class="btn  btn-primary">{{ __('Clear Cache') }}
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!--Webhook_Setting-->
                            <div id="Webhook_Setting" class="card">
                                <div class="row justify-content-center">
                                    <div class="col-md-12">
                                        <div class="card-header">
                                            <div class="row">
                                                <div class="col-lg-8 col-md-8 col-sm-8">
                                                    <h5 class="">{{ __('Webhook Settings') }}</h5>
                                                    <small class="text-secondary font-weight-bold">
                                                        {{ __('Edit your Webhook Settings') }}
                                                    </small>
                                                </div>
                                                <div class="col-lg-4 col-md-4 col-sm-4 text-end">
                                                    <div class="btn btn-sm btn-primary btn-icon m-1">
                                                        <a href="#" data-bs-toggle="tooltip"
                                                            data-bs-placement="top" title="{{ __('Create Webhook') }}"
                                                            data-url="{{ route('webhook.create') }}" data-size="md"
                                                            data-ajax-popup="true"
                                                            data-title="{{ __('Create New Webhook') }}">
                                                            <i class="ti ti-plus text-white"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-body">
                                            <div class="table-responsive">
                                                <table class="table">
                                                    <thead>
                                                        <tr>
                                                            {{-- <th scope="sort">{{ __('Id') }}</th> --}}
                                                            <th scope="sort">{{ __('Module') }}</th>
                                                            <th scope="sort">{{ __('Url') }}</th>
                                                            <th scope="sort">{{ __('Method') }}</th>
                                                            <th scope="sort" class="text-end">{{ __('Action') }}
                                                            </th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if (!empty($webhook) && count($webhook) > 0)
                                                            @foreach ($webhook as $data)
                                                                <tr>
                                                                    <td>{{ $data->module }}</td>
                                                                    <td>{{ $data->url }}</td>
                                                                    <td>{{ $data->method }}</td>
                                                                    <td class="text-end">
                                                                        <div class="action-btn bg-info ms-2">
                                                                            <a class="mx-3 btn btn-sm  align-items-center"
                                                                                data-url="{{ route('webhook.edit', $data->id) }}"
                                                                                data-size="md" data-ajax-popup="true"
                                                                                data-title="{{ __('Edit Webhook') }}"
                                                                                data-bs-toggle="tooltip"
                                                                                data-bs-original-title="{{ __('Edit Webhook') }}"
                                                                                data-bs-placement="top"
                                                                                class="edit-icon"
                                                                                data-original-title="{{ __('Edit') }}">
                                                                                <i class="ti ti-pencil text-white"></i>
                                                                            </a>
                                                                        </div>
                                                                        <div class="action-btn bg-danger ms-2"
                                                                            data-bs-toggle="tooltip"
                                                                            data-bs-placement="top"
                                                                            title="{{ __('Delete') }}">
                                                                            {!! Form::open(['method' => 'DELETE', 'route' => ['webhook.destroy', $data->id]]) !!}
                                                                            <a href="#!"
                                                                                class="mx-3 btn btn-sm show_confirm">
                                                                                <i class="ti ti-trash text-white"></i>
                                                                            </a>
                                                                            {!! Form::close() !!}
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            @endforeach
                                                        @else
                                                            <tr>
                                                                <td colspan="4">
                                                                    <div class="text-center">
                                                                        <i
                                                                            class="fas fa-user-slash text-primary fs-40"></i>
                                                                        <h2>{{ __('Opps...') }}</h2>
                                                                        <h6> {!! __('No leave request found...!') !!} </h6>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!--Cookie_Setting-->
                            <div class="card" id="Cookie_Setting">
                                {{ Form::model($settings, ['route' => 'dashboard-store', 'method' => 'post']) }}
                                <div
                                    class="card-header flex-column flex-lg-row  d-flex align-items-lg-center gap-2 justify-content-between">
                                    <h5>{{ __('Cookie Settings') }}</h5>
                                    <div class="d-flex align-items-center">
                                        {{ Form::label('enable_cookie', __('Enable cookie'), ['class' => 'col-form-label p-0 fw-bold me-3']) }}
                                        <div class="custom-control custom-switch" onclick="enablecookie()">
                                            <input type="checkbox" data-toggle="switchbutton" data-onstyle="primary"
                                                name="cookie_consent" class="form-check-input input-primary "
                                                id="cookie_consent"
                                                {{ $settings['cookie_consent'] == 'on' ? ' checked ' : '' }}>
                                            <label class="custom-control-label mb-1" for="cookie_consent"></label>
                                        </div>
                                    </div>
                                </div>
                                <div
                                    class="card-body cookieDiv {{ $settings['cookie_consent'] == 'off' ? 'disabledCookie ' : '' }}">
                                    <div class="row ">
                                        @if (\Utility::enable_chatgpt())
                                            <div class="text-end">
                                                <a href="#" class="btn btn-print-invoice btn-primary btn-icon"
                                                    data-size="lg" data-ajax-popup-over="true"
                                                    data-url="{{ route('generate', ['cookie']) }}"
                                                    data-bs-toggle="tooltip" data-bs-placement="top"
                                                    title="{{ __('Generate') }}"
                                                    data-title="{{ __('Generate product Name') }}">
                                                    <i class="fas fa-robot"></i>{{ __(' Generate with AI') }}
                                                </a>
                                            </div>
                                        @endif
                                        <div class="col-md-6">
                                            <div class="form-check form-switch custom-switch-v1" id="cookie_log">
                                                <input type="checkbox" name="cookie_logging"
                                                    class="form-check-input input-primary cookie_setting"
                                                    id="cookie_logging"{{ $settings['cookie_logging'] == 'on' ? ' checked ' : '' }}>
                                                <label class="form-check-label"
                                                    for="cookie_logging">{{ __('Enable logging') }}</label>
                                            </div>
                                            <div class="form-group">
                                                {{ Form::label('cookie_title', __('Cookie Title'), ['class' => 'col-form-label']) }}
                                                {{ Form::text('cookie_title', null, ['class' => 'form-control cookie_setting']) }}
                                            </div>
                                            <div class="form-group ">
                                                {{ Form::label('cookie_description', __('Cookie Description'), ['class' => ' form-label']) }}
                                                {!! Form::textarea('cookie_description', null, ['class' => 'form-control cookie_setting', 'rows' => '3']) !!}
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check form-switch custom-switch-v1 ">
                                                <input type="checkbox" name="necessary_cookies"
                                                    class="form-check-input input-primary" id="necessary_cookies"
                                                    checked onclick="return false">
                                                <label class="form-check-label"
                                                    for="necessary_cookies">{{ __('Strictly necessary cookies') }}</label>
                                            </div>
                                            <div class="form-group ">
                                                {{ Form::label('strictly_cookie_title', __(' Strictly Cookie Title'), ['class' => 'col-form-label']) }}
                                                {{ Form::text('strictly_cookie_title', null, ['class' => 'form-control cookie_setting']) }}
                                            </div>
                                            <div class="form-group ">
                                                {{ Form::label('strictly_cookie_description', __('Strictly Cookie Description'), ['class' => ' form-label']) }}
                                                {!! Form::textarea('strictly_cookie_description', null, [
                                                    'class' => 'form-control cookie_setting ',
                                                    'rows' => '3',
                                                ]) !!}
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <h5>{{ __('More Information') }}</h5>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group ">
                                                {{ Form::label('contact_us_description', __('Contact Us Description'), ['class' => 'col-form-label']) }}
                                                {{ Form::text('contact_us_description', null, ['class' => 'form-control cookie_setting']) }}
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group ">
                                                {{ Form::label('contact_us_url', __('Contact Us URL'), ['class' => 'col-form-label']) }}
                                                {{ Form::text('contact_us_url', null, ['class' => 'form-control cookie_setting']) }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <div class="row">
                                        <div class="form-group col-6 mb-0">
                                            @if (isset($settings['cookie_logging']) && $settings['cookie_logging'] == 'on')
                                                <label for="file"
                                                    class="form-label">{{ __('Download cookie accepted data') }}</label>
                                                <a href="{{ asset(Storage::url('uploads/sample')) . '/data.csv' }}"
                                                    class="btn btn-primary mr-2 ">
                                                    <i class="ti ti-download"></i>
                                                </a>
                                            @endif
                                        </div>
                                        <div class="form-group col-6 text-end mb-0">
                                            {{ Form::submit(__('Save Changes'), ['class' => 'btn btn-primary']) }}
                                        </div>
                                    </div>
                                </div>
                                {{ Form::close() }}
                            </div>

                            <!--Chat_GPT_Setting-->
                            <div class="card" id="pills-chatgpt-settings">
                                {{ Form::model($settings, ['route' => 'settings.chatgptkey', 'method' => 'post']) }}
                                <div class="card-header">
                                    <div class="row">
                                        <div class="col-lg-8 col-md-8 col-sm-8">
                                            <h5>{{ __('Chat GPT Key Settings') }}</h5>
                                            <small
                                                class="text-secondary font-weight-bold">{{ __('Edit your key details') }}</small>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 text-end">
                                            <input type="hidden" name="chatgpt" value="off">
                                            <input type="checkbox" name="chatgpt" id="chatgpt"
                                                data-toggle="switchbutton" data-onstyle="primary"
                                                {{ isset($settings['chatgpt']) && $settings['chatgpt'] == 'on' ? 'checked="checked"' : '' }}>
                                            <label class="custom-label form-label" for="chatgpt"></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="form-group col-md-6">
                                            {{ Form::label('chatgpt_key', __('Chat GPT Key'), ['class' => 'col-form-label']) }}
                                            {{ Form::text('chatgpt_key', isset($setting['chatgpt_key']) ? $setting['chatgpt_key'] : '', ['class' => 'form-control', 'placeholder' => __('Enter Chatgpt Key Here')]) }}
                                        </div>
                                        <div class="form-group col-md-6">
                                            {{ Form::label('chatgpt_model', __('Chat GPT Model'), ['class' => 'col-form-label']) }}
                                            {{ Form::text('chatgpt_model', isset($settings['chatgpt_model']) ? $settings['chatgpt_model'] : '', ['class' => 'form-control', 'placeholder' => __('Enter Chatgpt Model Here')]) }}
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer text-end">
                                    <button class="btn btn-primary" type="submit">{{ __('Save') }}</button>
                                </div>
                                {{ Form::close() }}
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('pagescript')
    <script>
        $('.colorPicker').on('click', function(e) {
            $('body').removeClass('custom-color');
            if (/^theme-\d+$/) {
                $('body').removeClassRegex(/^theme-\d+$/);
            }
            $('body').addClass('custom-color');
            $('.themes-color-change').removeClass('active_color');
            $(this).addClass('active_color');
            const input = document.getElementById("color-picker");
            setColor();
            input.addEventListener("input", setColor);

            function setColor() {
                $(':root').css('--color-customColor', input.value);
            }

            $(`input[name='color_flag`).val('true');
        });

        $('.themes-color-change').on('click', function() {

            $(`input[name='color_flag`).val('false');

            var color_val = $(this).data('value');
            $('body').removeClass('custom-color');
            if (/^theme-\d+$/) {
                $('body').removeClassRegex(/^theme-\d+$/);
            }
            $('body').addClass(color_val);
            $('.theme-color').prop('checked', false);
            $('.themes-color-change').removeClass('active_color');
            $('.colorPicker').removeClass('active_color');
            $(this).addClass('active_color');
            $(`input[value=${color_val}]`).prop('checked', true);
        });

        $.fn.removeClassRegex = function(regex) {
            return $(this).removeClass(function(index, classes) {
                return classes.split(/\s+/).filter(function(c) {
                    return regex.test(c);
                }).join(' ');
            });
        };
    </script>
    <script type="text/javascript">
        function enablecookie() {
            const element = $('#cookie_consent').is(':checked');
            $('.cookieDiv').addClass('disabledCookie');
            if (element == true) {
                $('.cookieDiv').removeClass('disabledCookie');
                $("#cookie_logging").attr('checked', true);
            } else {
                $('.cookieDiv').addClass('disabledCookie');
                $("#cookie_logging").attr('checked', false);
            }
        }
    </script>

    <script>
        var scrollSpy = new bootstrap.ScrollSpy(document.body, {
            target: '#useradd-sidenav',
            offset: 300,
        })
        $(".list-group-item").click(function() {
            $('.list-group-item').filter(function() {
                return this.href == id;
            }).parent().removeClass('text-primary');
        });


        $(document).on('change', '[name=storage_setting]', function() {
            if ($(this).val() == 's3') {
                $('.s3-setting').removeClass('d-none');
                $('.wasabi-setting').addClass('d-none');
                $('.local-setting').addClass('d-none');
            } else if ($(this).val() == 'wasabi') {
                $('.s3-setting').addClass('d-none');
                $('.wasabi-setting').removeClass('d-none');
                $('.local-setting').addClass('d-none');
            } else {
                $('.s3-setting').addClass('d-none');
                $('.wasabi-setting').addClass('d-none');
                $('.local-setting').removeClass('d-none');
            }
        });
    </script>

    <script>
        $(document).ready(function() {
            $('#gdpr_cookie').trigger('change');

            var type = window.location.hash.substr(1);
            $('.list-group-item').removeClass('active');
            $('.list-group-item').removeClass('text-primary');
            if (type != '') {
                $('a[href="#' + type + '"]').addClass('active').removeClass('text-primary');
            } else {
                $('.list-group-item:eq(0)').addClass('active').removeClass('text-primary');
            }
        });

        $(document).on('click', '.list-group-item', function() {
            setTimeout(() => {
                $('.list-group-item').removeClass('text-primary');
                var scrollSpy = new bootstrap.ScrollSpy(document.body, {
                    target: '#useradd-sidenav',
                    offset: 300,
                });
            }, 100);
        });

        $(document).on('change', '#gdpr_cookie', function() {
            $('.GDPR_Cookie_Text').hide();
            if ($("#gdpr_cookie").prop('checked') == true) {
                $('.GDPR_Cookie_Text').show();
            }
        });

        function check_theme(color_val) {
            $('input[value="' + color_val + '"]').prop('checked', true);
            $('a[data-value]').removeClass('active_color');
            $('a[data-value="' + color_val + '"]').addClass('active_color');
        }
    </script>

    <script>
        $(document).on("click", '.send_email', function(e) {
            e.preventDefault();
            var title = $(this).attr('data-title');

            var size = 'md';
            var url = $(this).attr('data-url');
            if (typeof url != 'undefined') {
                $("#commonModal .modal-title").html(title);
                $("#commonModal .modal-dialog").addClass('modal-' + size);
                $("#commonModal").modal('show');

                $.post(url, {
                    mail_driver: $("#mail_driver").val(),
                    mail_host: $("#mail_host").val(),
                    mail_port: $("#mail_port").val(),
                    mail_username: $("#mail_username").val(),
                    mail_password: $("#mail_password").val(),
                    mail_encryption: $("#mail_encryption").val(),
                    mail_from_address: $("#mail_from_address").val(),
                    mail_from_name: $("#mail_from_name").val(),
                }, function(data) {
                    $('#commonModal .modal-body').html(data);
                });
            }
        });

        $(document).on('submit', '#test_email', function(e) {
            e.preventDefault();
            $("#email_sending").show();
            var post = $(this).serialize();
            var url = $(this).attr('action');
            $.ajax({
                type: "post",
                url: url,
                data: post,
                cache: false,
                beforeSend: function() {
                    $('#test_email .btn-create').attr('disabled', 'disabled');
                },
                success: function(data) {
                    if (data.is_success) {
                        show_toastr('Success', data.message, 'success');
                    } else {
                        show_toastr('Error', data.message, 'error');
                    }
                    $("#email_sending").hide();
                    $('#commonModal').modal('hide');
                },
                complete: function() {
                    $('#test_email .btn-create').removeAttr('disabled');
                },
            });
        });
    </script>
@endpush
