@extends('layouts.main')

@section('page-title')
    {{ __('Employee') }}
@endsection

@section('content')
    <div class="dash-container">
        <div class="dash-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <div class="page-header-title">
                                <h4 class="m-b-10">{{ __('Employee') }}</h4>
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">{{ __('Home') }}</a></li>
                                <li class="breadcrumb-item">{{ __('Company') }}</li>
                                <li class="breadcrumb-item">{{ __('Employee') }}</li>
                            </ul>
                        </div>
                        <div class="col-md-6 d-flex justify-content-end text-right">
                            <div class="btn btn-sm btn-primary btn-icon m-1">
                                <a class="grid" data-bs-toggle="tooltip" data-bs-placement="top"
                                    title="{{ __('Grid view') }}">
                                    <i class="ti ti-layout-grid text-white"></i>
                                </a>

                                <a class="list" data-bs-toggle="tooltip" data-bs-placement="top"
                                    title="{{ __('list view') }}">
                                    <i class="ti ti-list-check text-white"></i>
                                </a>
                            </div>
                            <div class="btn btn-sm btn-primary btn-icon m-1">
                                <a href="{{ url('userLogin') }}">
                                    <i class="ti ti-user-check text-white" data-bs-toggle="tooltip" data-bs-placement="top"
                                        title="{{ __('User Login History') }}"></i>
                                </a>
                            </div>

                            <div class="btn btn-sm btn-primary btn-icon m-1">
                                <a href="{{ route('employee.export') }}">
                                    <i class="ti ti-database-export text-white" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="{{ __('Export Employee CSV file') }}"></i>
                                </a>
                            </div>

                            <div class="btn btn-sm btn-primary btn-icon m-1">
                                <a href="#" data-url="{{ route('employee.file.import') }}" data-ajax-popup="true"
                                    data-title="{{ __('Import Employee CSV file') }}">
                                    <i class="ti ti-database-import text-white" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="{{ __('Import Employee CSV file') }}"></i>
                                </a>
                            </div>
                            <div class="btn-group card-option rotas_filter_main_div">
                                <button type="button" class="dropdown-toggle btn btn-sm btn-primary btn-icon m-1"
                                    data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="ti ti-dots-vertical" data-bs-toggle="tooltip" data-bs-placement="top"
                                        title="{{ __('Menu') }}"></i>
                                </button>
                                <div class="dropdown-menu dropdown-menu-end" style="">
                                    <a href="{{ url('employees') }}" onclick="window.location.href=this;"
                                        class="dropdown-item">{{ __('View Employees') }}</a>
                                    <a href="{{ url('past-employees') }}" onclick="window.location.href=this;"
                                        class="dropdown-item">{{ __('Deleted Employees') }}</a>
                                </div>
                            </div>

                            <div class="btn btn-sm btn-primary btn-icon m-1">
                                <a href="#" data-bs-toggle="tooltip" data-bs-placement="top"
                                    title="{{ __('Create New Employee') }}" data-url="{{ route('employees.create') }}"
                                    data-size="md" data-ajax-popup="true" data-title="{{ __('Create New Employee') }}">
                                    <i class="ti ti-plus text-white"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="card emp-card">
                        <div class="card-body">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-auto mb-3 mb-sm-0">
                                    <div class="d-flex align-items-center">
                                        <div class="theme-avtar bg-success">
                                            <i class="ti ti-users"></i>
                                        </div>
                                        <div class="ms-3">
                                            <small class="text-muted"> {{ $box['total_employee'] }}</small>
                                            <h6 class="m-0">{{ __('Total Employee  ') }}</h6>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto text-end">
                                    <h4 class="m-0">{{ $box['month_employee'] }}</h4>
                                    <small class="text-muted">{{ __('Current month new employee') }}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="card emp-card">
                        <div class="card-body">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-auto mb-3 mb-sm-0">
                                    <div class="d-flex align-items-center">
                                        <div class="theme-avtar bg-warning">
                                            <i class="ti ti-calendar-time"></i>
                                        </div>
                                        <div class="ms-3">
                                            <small class="text-muted">{{ $box['month_rotas'] }}</small>
                                            <h6 class="m-0">{{ __('Current Month Rotas') }}</h6>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto text-end">

                                    <h4 class="m-0"> {{ \App\Models\User::CompanycurrencySymbol() }}
                                        {{ $box['month_rotas_cost'] }}</h4>
                                    <small class="text-muted">{{ __('Total cost : ') }}</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="card emp-card">
                        <div class="card-body">
                            <div class="row align-items-center justify-content-between">
                                <div class="col-auto mb-3 mb-sm-0">
                                    <div class="d-flex align-items-center">
                                        <div class="theme-avtar bg-danger">
                                            <i class="ti ti-user-off"></i>
                                        </div>
                                        <div class="ms-3">
                                            <small class="text-muted">{{ $box['month_leave'] }}</small>
                                            <h6 class="m-0">{{ __('Current Month Leave') }}</h6>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto text-end">
                                    <h4 class="m-0">{{ $box['month_comapany_leave_use'] }}</h4>
                                    <small class="text-muted">{{ __('Company Leave ') }} </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <section class="section list_view" style="display:none">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="card">
                            <div class="card-header card-body table-border-style">
                                <h5></h5>
                                <div class="table-responsive">
                                    <table class="table mb-0 pc-dt-simple">
                                        <thead>
                                            <tr>
                                                <th scope="sort">{{ __('Name') }}</th>
                                                <th scope="sort">{{ __('Status') }}</th>
                                                <th scope="sort">{{ __('Email') }}</th>
                                                <th scope="sort">{{ __('Locations') }}</th>
                                                <th scope="sort">{{ __('Role') }}</th>
                                                <th scope="sort">{{ __('Wage / Salary') }}</th>
                                                <th scope="sort">{{ __('Weekly Hours') }}</th>
                                                <th scope="sort" class="text-end"> {{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if (!empty($employees) && count($employees) > 0)
                                                @foreach ($employees as $employee)
                                                    <tr
                                                        data-name="{{ $employee->first_name }} {{ $employee->last_name }}">
                                                        <th>
                                                            <div href="#" class="name h6 mb-0 text-sm">
                                                                {{ $employee->first_name }}
                                                                {{ $employee->last_name }}</div>
                                                        </th>
                                                        <td>
                                                            @if ($employee->type == 'company')
                                                                <span
                                                                    class="badge bg-primary p-2 px-3 rounded">{{ __('Administrator') }}</span>
                                                            @elseif($employee->acount_type == 1)
                                                                <span
                                                                    class="badge bg-success p-2 px-3 rounded">{{ __('Admin') }}</span>
                                                            @elseif($employee->acount_type == 2)
                                                                <span
                                                                    class="badge bg-info p-2 px-3 rounded">{{ __('Manager') }}</span>
                                                            @else
                                                                <span
                                                                    class="badge bg-danger p-2 px-3 rounded">{{ __('Employee') }}</span>
                                                            @endif
                                                        </td>
                                                        <td> {{ !empty($employee->email) ? $employee->email : '' }} </td>
                                                        <td> {{ $employee->getLocatopnName($employee->id) }} </td>
                                                        <td> {!! $employee->getDefaultEmployeeRole($employee->id) !!} </td>
                                                        <td> {{ $employee->getwagesalary($employee->id) }} </td>
                                                        <td> {{ $employee->getweeklyhours($employee->id) }} </td>
                                                        <td class="Action text-end rtl-actions">
                                                            <span>
                                                                @if ($employee->type != 'company' && Auth::user()->type == 'company')
                                                                    @if ($employee->password == '' || $employee->password == null)
                                                                        <div class="action-btn bg-secondary ms-2">
                                                                            <a href="#"
                                                                                class="mx-3 btn btn-sm align-items-center"
                                                                                onclick="showerrormsg()">
                                                                                <i class="ti ti-settings text-white"
                                                                                    data-bs-toggle="tooltip"
                                                                                    data-bs-placement="top"
                                                                                    title="{{ __('Manage user type') }}"></i>
                                                                            </a>
                                                                        </div>
                                                                    @else
                                                                        <div
                                                                            class="action-btn bg-secondary ms-2 {{ $employee->password == '' ? 'd-none' : '' }}">
                                                                            <a href="#"
                                                                                class="mx-3 btn btn-sm align-items-center"
                                                                                data-ajax-popup="true"
                                                                                data-title="{{ __('Manage user type') }}"
                                                                                data-size="lg"
                                                                                data-url="{{ route('employee.manage_permission', $employee->id) }}">
                                                                                <i class="ti ti-settings text-white"
                                                                                    data-bs-toggle="tooltip"
                                                                                    data-bs-placement="top"
                                                                                    title="{{ __('Manage user type') }}"></i>
                                                                            </a>
                                                                        </div>
                                                                    @endif
                                                                @endif

                                                                @if ($employee->password == '')
                                                                    <div class="action-btn bg-info ms-2">
                                                                        <a href="#"
                                                                            class="mx-3 btn btn-sm align-items-center"
                                                                            data-ajax-popup="true"
                                                                            data-title="{{ __('Manage type') }}"
                                                                            data-size="md"
                                                                            data-url="{{ route('employee.set_password', $employee->id) }}">
                                                                            <i class="ti ti-lock text-white"
                                                                                data-bs-toggle="tooltip"
                                                                                data-bs-placement="top"
                                                                                title="{{ __('Set Password') }}"></i>
                                                                        </a>
                                                                    </div>
                                                                @endif

                                                                <div class="action-btn bg-info ms-2">
                                                                    <a href="{{ url('profile/' . Crypt::encrypt($employee->id) . '') }}"
                                                                        class="mx-3 btn btn-sm  align-items-center">
                                                                        <i class="ti ti-pencil text-white"
                                                                            data-bs-toggle="tooltip"
                                                                            data-bs-placement="top"
                                                                            title="{{ __('Edit') }}"></i>
                                                                    </a>
                                                                </div>

                                                                <div class="action-btn bg-warning ms-2">
                                                                    <a href="#"
                                                                        class="mx-3 btn btn-sm  align-items-center"
                                                                        data-size="md"
                                                                        data-url="{{ route('employee.reset', \Crypt::encrypt($employee->id)) }}"
                                                                        data-ajax-popup="true"
                                                                        data-title="{{ __('Reset Password') }}">
                                                                        <i class="ti ti-shield-lock text-white"
                                                                            data-bs-toggle="tooltip"
                                                                            data-bs-placement="top"
                                                                            title="{{ __('Reset Password') }}"></i>
                                                                    </a>
                                                                </div>

                                                                <div class="action-btn bg-danger ms-2"
                                                                    data-bs-toggle="tooltip" data-bs-placement="top"
                                                                    title="{{ __('Delete') }}">
                                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['employees.destroy', $employee->id]]) !!}
                                                                    <a href="#!"
                                                                        class="mx-3 btn btn-sm show_confirm">
                                                                        <i class="ti ti-trash text-white"></i>
                                                                    </a>
                                                                    {!! Form::close() !!}
                                                                </div>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            @else
                                                <tr>
                                                    <td colspan="7">
                                                        <div class="text-center">
                                                            <i class="fas fa-users text-primary fs-40"></i>
                                                            <h2>{{ __('Opps...') }}</h2>
                                                            <h6> {!! __('No Employee found...!') !!} </h6>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endif
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section class="section grid_view">


                <div class="row mt-3">
                    {{-- @dump($employees) --}}
                    @foreach ($employees as $user)
                        <div class="col-xl-3">

                            <div class="card  text-center">
                                <div class="card-header border-0 pb-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <h6 class="mb-0">
                                            {{-- <div class="badge p-2 px-3 rounded bg-primary">{{$user->name }}</div> --}}


                                            <div class="badge">
                                                @if ($user->type == 'company')
                                                    <span
                                                        class="badge bg-primary p-2 px-3 rounded">{{ __('Administrator') }}</span>
                                                @elseif($user->acount_type == 1)
                                                    <span
                                                        class="badge bg-success p-2 px-3 rounded">{{ __('Admin') }}</span>
                                                @elseif($user->acount_type == 2)
                                                    <span
                                                        class="badge bg-info p-2 px-3 rounded">{{ __('Manager') }}</span>
                                                @else
                                                    <span
                                                        class="badge bg-danger p-2 px-3 rounded">{{ __('Employee') }}</span>
                                                @endif
                                            </div>


                                            {{-- @can('Delete User') --}}
                                            {{-- <div
                                                    class="action-btn  {{ $user->user_status == 1 ? 'bg-success' : 'bg-danger' }}  ms-2 sd">
                                                    <a href="#" data-confirm="{{ __('Are You Sure?') }}"
                                                        data-text="Do you want to continue?" data-bs-toggle="tooltip"
                                                        data-confirm-yes="status-form-{{ $user->id }}"
                                                        class="bs-pass-para mx-3 btn btn-sm d-inline-flex align-items-center">
                                                        @if ($user->user_status == 1)
                                                            <i class="ti ti-user-check text-white" data-bs-toggle="tooltip"
                                                                title="{{ __('Active') }}"
                                                                data-title="{{ __('Active') }}"></i>
                                                        @else
                                                            <i class="ti ti-user-x text-white" data-bs-toggle="tooltip"
                                                                title="{{ __('Deactive') }}"
                                                                data-title="{{ __('Deactive') }}"></i>
                                                        @endif
                                                    </a>
                                                </div> --}}
                                            {{-- @endcan --}}


                                        </h6>
                                    </div>
                                    <div class="card-header-right">
                                        <div class="btn-group card-option">
                                            {{-- @if (Auth::user()->isSuperAdmin()) --}}

                                            <button type="button" class="btn dropdown-toggle" data-bs-toggle="dropdown"
                                                aria-haspopup="true" aria-expanded="false">
                                                <i class="feather icon-more-vertical"></i>
                                            </button>

                                            {{-- @endif --}}
                                            <div class="dropdown-menu dropdown-menu-end">
                                                {{-- @if ($user->is_disable == 1) --}}
                                                <a href="{{ url('profile/' . Crypt::encrypt($user->id) . '') }}"
                                                    class="dropdown-item" data-size="md"
                                                    data-title="{{ __('Update User') }}"><i
                                                        class="ti ti-pencil"></i><span
                                                        class="ms-2">{{ __('Edit') }}</span></a>
                                                {{-- @endif --}}

                                                @if ($user->password == '')
                                                    {{-- <div class="action-btn bg-info ms-2"> --}}
                                                    <a href="#" class="dropdown-item" data-ajax-popup="true"
                                                        data-title="{{ __('Manage type') }}" data-size="md"
                                                        data-url="{{ route('employee.set_password', $user->id) }}">
                                                        <i class="ti ti-lock" data-bs-toggle="tooltip"
                                                            data-bs-placement="top" title="{{ __('Set Password') }}"></i>
                                                        <span class="ms-1">{{ __('Set Password') }}</span>
                                                    </a>
                                                    {{-- </div> --}}
                                                @endif


                                                @if ($user->password !== '')
                                                    <a href="#" class="dropdown-item" data-ajax-popup="true"
                                                        data-size="md" data-title="{{ __('Change Password') }}"
                                                        data-url="{{ route('employee.reset', \Crypt::encrypt($employee->id)) }}"><i
                                                            class="ti ti-key"></i>
                                                        <span class="ms-1">{{ __('Reset Password') }}</span></a>
                                                @endif

                                                {{--  --}}
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['employees.destroy', $user->id]]) !!}
                                                <a href="#" class="dropdown-item show_confirm" data-size="md"
                                                    data-title="{{ __('Delet') }}"><i class="ti ti-trash  "></i>
                                                    <span class="ms-1">{{ __('Delete') }}</span></a>
                                                {!! Form::close() !!}

                                                @if ($user->is_disable == 1)
                                                    <a href="{{ route('empl.disable', $user->id) }}"
                                                        class="dropdown-item" data-ajax-popup=""><i
                                                            class="ti ti-road-sign text-danger"></i>
                                                        <span class="ms-1 text-danger">{{ __('Disable') }}</span></a>
                                                @endif

                                                @if ($user->is_disable == 0 && $user->password == '')
                                                    <a class="dropdown-item" data-ajax-popup="true" data-size="md"
                                                        data-title="{{ __('Password') }}"
                                                        data-url="{{ route('employee.password.update', \Crypt::encrypt($user->id)) }}"><i
                                                            class="ti ti-road-sign text-success"></i>
                                                        <span class="ms-1 text-success">{{ __('Enable') }}</span></a>
                                                @elseif ($user->is_disable == 0 && $user->password !== '')
                                                    <a href="{{ route('empl.eneble', $user->id) }}" class="dropdown-item"
                                                        data-ajax-popup=""><i class="ti ti-road-sign text-success"></i>
                                                        <span class="ms-1 text-success">{{ __('Enable') }}</span></a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>



                                <div class="card-body">

                                    <div class="avtar">
                                        <a class="theme-avtar rounded-circle" target="_blank">
                                            <img alt="" alt="wid-75 rounded-circle grid-img"
                                                src="{{ \App\Models\Utility::get_file($user->getAvatar()) ?? '' }}"
                                                class="theme-avtar img-fluid rounded-circle wid-75 rounded-circle grid-img">

                                        </a>

                                    </div>

                                    <h4 class="mt-2">{{ $user->first_name }}</h4>

                                    <small>{{ $user->email }}</small>



                                    @if (\Auth::user()->type == 'Super Admin')
                                        <div class="mt-4">
                                            <div class="row justify-content-between align-items-center">
                                                <div class="col-6 text-center mb-2 pb-3">
                                                    <span
                                                        class="d-block font-bold mb-0">{{ !empty($user->getPlan) ? $user->getPlan->name : '' }}</span>
                                                </div>

                                                <div class="col-6 text-center mb-2 pb-3">
                                                    <a class="text-muted">{{ __('Users : ') }}
                                                        {{ $user->users }}</a>
                                                </div>

                                                <div class="col-6 text-center Id mb-2">
                                                    <div class="col-12 text-center Id mb-2">
                                                        <a href="#"
                                                            data-url="{{ route('plan.upgrade', $user->id) }}"
                                                            data-size="lg" data-ajax-popup="true"
                                                            data-title="{{ __('Upgrade Plan') }}"
                                                            class="btn small--btn btn-outline-primary text-sm">{{ __('Upgrade Plan') }}</a>
                                                    </div>
                                                </div>

                                                <div class="col-6 text-center Id mb-2">
                                                    <div class="col-12 text-center Id mb-2">
                                                        <a href="#"
                                                            data-url="{{ route('owner.info', $user->id) }}"
                                                            data-size="lg" data-ajax-popup="true"
                                                            data-title="{{ __('Owner Info') }}"
                                                            title="{{ __('Owner Info') }}"
                                                            data-bs-original-title="{{ __('Owner Info') }}"
                                                            class="btn small--btn btn-outline-primary text-sm">{{ __('AdminHub') }}</a>
                                                    </div>
                                                </div>

                                                <div class="col-12 text-center pb-2">
                                                    <a>{{ __('Plan Expire : ') }}
                                                        {{ !empty($user->plan_expire_date) ? \Auth::user()->dateFormat($user->plan_expire_date) : 'Lifetime' }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                    {{-- @can('Create Employee') --}}
                    <div class="col-xl-3 col-lg-4 col-sm-4">
                        <a href="#" class="btn-addnew-project  " data-ajax-popup="true"
                            data-url="{{ route('employees.create') }}" data-title="{{ __('Create New Employee') }}"
                            data-bs-toggle="tooltip" title="{{ __('Create New Employee') }}" class="btn btn-primary"
                            data-bs-original-title="{{ __('Create') }}">
                            <div class="badge bg-primary proj-add-icon">
                                <i class="ti ti-plus"></i>
                            </div>
                            <h6 class="mt-4 mb-2">
                                @if (Auth::user()->parent_id == 0)
                                    {{ __('Add Employee') }}
                                @else
                                    {{ __('Add User') }}
                                @endif
                            </h6>

                            <p class="text-muted text-center">
                                @if (Auth::user()->parent_id == 0)
                                    {{ __('Click here to add new employee') }}
                                @else
                                    {{ __('Click here to add new User') }}
                                @endif
                            </p>
                        </a>
                    </div>
                    {{-- @endcan --}}

                </div>

            </section>
        </div>
    </div>
@endsection

@push('pagescript')
    <script>
        $(document).ready(function() {

            $(".grid").hide();
            $(".grid").click(function() {
                $(".grid_view").show();
                $(".list_view").hide();
                $(".list").show();
                $(".grid").hide();
            });

            $(".list").click(function() {
                $(".grid").show();
                $(".list_view").show();
                $(".grid_view").hide();
                $(".list").hide();
                $(".grid").show();
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $(document).on('keyup', '.search-user', function() {
                var value = $(this).val();
                $('.employee_tableese tbody>tr').each(function(index) {
                    var name = $(this).attr('data-name');
                    if (name.includes(value)) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
        });

        function showerrormsg(event) {
            show_toastr('{{ __('Error') }}', '{!! __('You have to set password to manage user type') !!}', 'error');
        }
    </script>
@endpush
