<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\LoginDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginDetailController extends Controller
{
    public function index(Request $request)
    {
        $user = Auth::user();
        $created_by = $user->get_created_by();
        $month = [
            ''   => __('All'),
            '01' => __('JAN'),
            '02' => __('FEB'),
            '03' => __('MAR'),
            '04' => __('APR'),
            '05' => __('MAY'),
            '06' => __('JUN'),
            '07' => __('JUL'),
            '08' => __('AUG'),
            '09' => __('SEP'),
            '10' => __('OCT'),
            '11' => __('NOV'),
            '12' => __('DEC'),
        ];

        $user = User::where('created_by',$created_by)->get()->pluck('first_name','id');
        $user->prepend('All', '');

        $users = \DB::table('login_details')
                ->join('users', 'login_details.user_id', '=', 'users.id')
                ->select(\DB::raw('login_details.*, users.first_name  as user_name ,users.last_name as last_name , users.email as user_email'))
                ->where(['login_details.created_by' => \Auth::user()->id]);
                if(!empty($request->username))
                {
                    $users->where('user_id',$request->username);
                }
                if(!empty($request->month))
                {
                    $users->whereMonth('date',$request->month);
                }
                $users = $users->get();
        return view('user.userLog', compact('users','month','user'));
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        //
    }

    public function show(LoginDetail $loginDetail,$id)
    {
        $users = LoginDetail::find($id);
        // $request = json_decode($userlog->details,true);
        // dd($request);
        return view('user.viewUserLog', compact('users'));
    }

    public function edit(LoginDetail $loginDetail)
    {

    }

    public function update(Request $request, LoginDetail $loginDetail)
    {
        //
    }

    public function destroy(LoginDetail $loginDetail,$id)
    {
        $userlog = LoginDetail::find($id);
        $userlog->delete();
        return redirect()->back()->with('success', 'User Log Deleted Successfully.');
    }
}
