<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Facades\Auth;
use App\Models\Utility;

class LanguageController extends Controller
{
    public function changeLanguage($lang)
    {
        $user = Auth::user();
        $created_by = $user->get_created_by();
        $user->lang = $lang;
        $user->save();
        if($user->lang == 'ar' || $user->lang =='he'){
            $value = 'on';
        }
        else{
            $value = 'off';
        }
        if($user->type == 'company'){
            \DB::insert(
                'insert into settings (`value`, `name`,`created_by`) values (?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`) ', [
                    $value,
                    'SITE_RTL',
                    $created_by,
                ]
            );
        }
        else{
            \DB::insert(
                'insert into settings (`value`, `name`,`created_by`) values (?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`) ', [
                    $value,
                    'SITE_RTL',
                    $created_by,
                ]
            );
        }

        return redirect()->back()->with('success', __('Language Changed Successfully!'));
    }

    public function manageLanguage($currantLang)
    {
        // $languages = Utility::langList();
        $languages = Language::get()->pluck('name','languages_code')->toArray();

        $settings = Utility::settings();

        if(!empty($settings['disable_lang'])){
            $disabledLang = explode(',',$settings['disable_lang']);
        }
        else{
            $disabledLang = [];
        }
        $dir       = base_path() . '/resources/lang/' . $currantLang;
        if(!is_dir($dir))
        {
            $dir = base_path() . '/resources/lang/en';
        }
        $arrLabel   = json_decode(file_get_contents($dir . '.json'));
        $arrFiles   = array_diff(
            scandir($dir), array( '..', '.', )
        );
        $arrMessage = [];
        foreach($arrFiles as $file)
        {
            $fileName = basename($file, ".php");
            $fileData = $myArray = include $dir . "/" . $file;
            if(is_array($fileData))
            {
                $arrMessage[$fileName] = $fileData;
            }
        }

        return view('languages.index', compact('settings','disabledLang','languages', 'currantLang', 'arrLabel', 'arrMessage'));
    }

    public function storeLanguageData(Request $request, $currantLang)
    {
        $Filesystem = new Filesystem();
        $dir        = base_path() . '/resources/lang/';
        if(!is_dir($dir))
        {
            mkdir($dir);
            @chmod($dir, 0777);
        }

        $jsonFile = $dir . "/" . $currantLang . ".json";
        if(isset($request->label) && !empty($request->label))
        {
            file_put_contents($jsonFile, json_encode($request->label));
        }
        $langFolder = $dir . "/" . $currantLang;

        if(!is_dir($langFolder))
        {
            mkdir($langFolder);
            @chmod($langFolder, 0777);
        }

        if(isset($request->message) && !empty($request->message))
        {
            foreach($request->message as $fileName => $fileData)
            {
                $content = "<?php return [";
                $content .= $this->buildArray($fileData);
                $content .= "];";
                file_put_contents($langFolder . "/" . $fileName . '.php', $content);
            }
        }

        return redirect()->route('manage.language', [$currantLang])->with('success', __('Language Saved Successfully!'));
    }

    public function buildArray($fileData)
    {
        $content = "";
        foreach($fileData as $lable => $data)
        {
            if(is_array($data))
            {
                $content .= "'$lable'=>[" . $this->buildArray($data) . "],";
            }
            else
            {
                $content .= "'$lable'=>'" . addslashes($data) . "',";
            }
        }

        return $content;
    }

    public function createLanguage()
    {
        return view('languages.create');
    }

    public function storeLanguage(Request $request)
    {
        $Filesystem = new Filesystem();
        $langCode   = strtolower($request->code);
        $langDir    = base_path() . '/resources/lang/';
        $dir        = $langDir;
        if(!is_dir($dir))
        {
            mkdir($dir);
            @chmod($dir, 0777);
        }
        $dir      = $dir . '/' . $langCode;
        $jsonFile = $dir . ".json";
        \File::copy($langDir . 'en.json', $jsonFile);
        if(!is_dir($dir))
        {
            mkdir($dir);
            @chmod($dir, 0777);
        }
        $language = Language::where('languages_code',$request->code)->get();
        if(isset($language))
        {
            $language = new Language();
            $language->languages_code = $request->code;
            $language->name = $request->name;
            $language->save();
        }
        $Filesystem->copyDirectory($langDir . "en", $dir . "/");

        return redirect()->route('manage.language', [$langCode])->with('success', __('Language Created Successfully!'));
    }

    public function destroyLang($lang)
    {
        $default_lang = env('DEFAULT_LANG') ?? 'en';

        $langDir = base_path() . '/resources/lang/';
        if(is_dir($langDir))
        {
            $languages = Language::where('languages_code',$lang)->get()->first();
            $languages->delete();
            // remove directory and file
            Utility::delete_directory($langDir . $lang);
            unlink($langDir . $lang . '.json');
            // update user that has assign deleted language.
            User::where('lang', 'LIKE', $lang)->update(['lang' => $default_lang]);
        }
        return redirect()->route('manage.language', [Auth::user()->lang])->with('success', __('Language Deleted Successfully!'));
    }

    public function disableLang(Request $request)
    {
        $user = Auth::user();
        $created_by = $user->get_created_by();

        $settings = Utility::settings();
        $disablelang  = '';
        if($request->mode == 'off'){
            if(!empty($settings['disable_lang'])){
                $disablelang = $settings['disable_lang'];
                $disablelang=$disablelang.','. $request->lang;
            }
            else{
                $disablelang = $request->lang;
            }
            \DB::insert(
                'insert into settings (`value`, `name`,`created_by`) values (?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`) ', [
                    $disablelang,
                    'disable_lang',
                    $created_by,

                ]
            );
            $data['message'] = __('Language Disabled Successfully');
            $data['status'] = 200;
            return $data;
        }else{
        $disablelang = $settings['disable_lang'];
        $parts = explode(',', $disablelang);
        while(($i = array_search($request->lang,$parts)) !== false) {
            unset($parts[$i]);
        }
        \DB::insert(
            'insert into settings (`value`, `name`,`created_by`) values (?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`) ', [
                implode(',', $parts),
                'disable_lang',
                $created_by,
            ]
        );
        $data['message'] = __('Language Enabled Successfully');
        $data['status'] = 200;
        return $data;
        }
    }
}

